/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress;

import java.util.EnumSet;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.conf.DMLConfig;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.PlanningCoCoder;
import org.apache.sysds.runtime.compress.colgroup.ColGroup;

public class CompressionSettingsBuilder {
    private double samplingRatio = 1.0;
    private boolean allowSharedDictionary = false;
    private boolean transposeInput = true;
    private boolean skipList = true;
    private int seed = -1;
    private boolean investigateEstimate = false;
    private boolean lossy = false;
    private EnumSet<ColGroup.CompressionType> validCompressions;
    private boolean sortValuesByLength = false;
    private PlanningCoCoder.PartitionerType columnPartitioner = PlanningCoCoder.PartitionerType.STATIC;
    private int maxStaticColGroupCoCode = 1;

    public CompressionSettingsBuilder() {
        String[] validCompressionsString;
        DMLConfig conf = ConfigurationManager.getDMLConfig();
        this.lossy = conf.getBooleanValue("sysds.compressed.lossy");
        this.validCompressions = EnumSet.of(ColGroup.CompressionType.UNCOMPRESSED);
        for (String comp : validCompressionsString = conf.getTextValue("sysds.compressed.valid.compressions").split(",")) {
            this.validCompressions.add(ColGroup.CompressionType.valueOf(comp));
        }
    }

    public CompressionSettingsBuilder copySettings(CompressionSettings that) {
        this.samplingRatio = that.samplingRatio;
        this.allowSharedDictionary = that.allowSharedDictionary;
        this.transposeInput = that.transposeInput;
        this.seed = that.seed;
        this.investigateEstimate = that.investigateEstimate;
        this.validCompressions = EnumSet.copyOf(that.validCompressions);
        return this;
    }

    public CompressionSettingsBuilder setLossy(boolean lossy) {
        this.lossy = lossy;
        return this;
    }

    public CompressionSettingsBuilder setSamplingRatio(double samplingRatio) {
        this.samplingRatio = samplingRatio;
        return this;
    }

    public CompressionSettingsBuilder setSortValuesByLength(boolean sortValuesByLength) {
        this.sortValuesByLength = sortValuesByLength;
        return this;
    }

    public CompressionSettingsBuilder setAllowSharedDictionary(boolean allowSharedDictionary) {
        this.allowSharedDictionary = allowSharedDictionary;
        return this;
    }

    public CompressionSettingsBuilder setTransposeInput(boolean transposeInput) {
        this.transposeInput = transposeInput;
        return this;
    }

    public CompressionSettingsBuilder setSkipList(boolean skipList) {
        this.skipList = skipList;
        return this;
    }

    public CompressionSettingsBuilder setSeed(int seed) {
        this.seed = seed;
        return this;
    }

    public CompressionSettingsBuilder setInvestigateEstimate(boolean investigateEstimate) {
        this.investigateEstimate = investigateEstimate;
        return this;
    }

    public CompressionSettingsBuilder setValidCompressions(EnumSet<ColGroup.CompressionType> validCompressions) {
        if (!validCompressions.contains((Object)ColGroup.CompressionType.UNCOMPRESSED)) {
            validCompressions.add(ColGroup.CompressionType.UNCOMPRESSED);
        }
        this.validCompressions = validCompressions;
        return this;
    }

    public CompressionSettingsBuilder addValidCompression(ColGroup.CompressionType cp) {
        this.validCompressions.add(cp);
        return this;
    }

    public CompressionSettingsBuilder clearValidCompression() {
        this.validCompressions = EnumSet.of(ColGroup.CompressionType.UNCOMPRESSED);
        return this;
    }

    public CompressionSettingsBuilder setColumnPartitioner(PlanningCoCoder.PartitionerType columnPartitioner) {
        this.columnPartitioner = columnPartitioner;
        return this;
    }

    public CompressionSettingsBuilder setmaxStaticColGroupCoCode(int maxStaticColGroupCoCode) {
        this.maxStaticColGroupCoCode = maxStaticColGroupCoCode;
        return this;
    }

    public CompressionSettings create() {
        return new CompressionSettings(this.samplingRatio, this.allowSharedDictionary, this.transposeInput, this.skipList, this.seed, this.investigateEstimate, this.lossy, this.validCompressions, this.sortValuesByLength, this.columnPartitioner, this.maxStaticColGroupCoCode);
    }
}

