/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.udf.lib;

import org.apache.sysml.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.udf.FunctionParameter;
import org.apache.sysml.udf.Matrix;
import org.apache.sysml.udf.PackageFunction;

public class GatherWrapper
extends PackageFunction {
    private static final long serialVersionUID = 1L;
    private static final String OUTPUT_FILE = "TMP";
    private Matrix ret;

    @Override
    public int getNumFunctionOutputs() {
        return 1;
    }

    @Override
    public FunctionParameter getFunctionOutput(int pos) {
        if (pos == 0) {
            return this.ret;
        }
        throw new RuntimeException("Invalid function output being requested");
    }

    @Override
    public void execute() {
        try {
            Matrix inM = (Matrix)this.getFunctionInput(0);
            MatrixObject mo = inM.getMatrixObject();
            MatrixBlock mb = (MatrixBlock)mo.acquireRead();
            int len1 = mb.getNumRows();
            int len2 = (int)mb.getNonZeros();
            double[][] outM = new double[len2][1];
            int pos = 0;
            for (int i = 0; i < len1; ++i) {
                double val = mb.quickGetValue(i, 0);
                if (val == 0.0) continue;
                outM[pos++][0] = i + 1;
            }
            mo.release();
            String dir = this.createOutputFilePathAndName(OUTPUT_FILE);
            this.ret = new Matrix(dir, mb.getNonZeros(), 1L, Matrix.ValueType.Double);
            this.ret.setMatrixDoubleArray(outM);
        }
        catch (Exception e) {
            throw new RuntimeException("Error executing external order function", e);
        }
    }
}

