/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.controlprogram.parfor;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.spark.TaskContext;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.util.LongAccumulator;
import org.apache.sysml.runtime.codegen.CodegenUtils;
import org.apache.sysml.runtime.controlprogram.caching.CacheBlock;
import org.apache.sysml.runtime.controlprogram.caching.CacheableData;
import org.apache.sysml.runtime.controlprogram.parfor.CachedReuseVariables;
import org.apache.sysml.runtime.controlprogram.parfor.ParForBody;
import org.apache.sysml.runtime.controlprogram.parfor.ParWorker;
import org.apache.sysml.runtime.controlprogram.parfor.RemoteParForUtils;
import org.apache.sysml.runtime.controlprogram.parfor.Task;
import org.apache.sysml.runtime.controlprogram.parfor.stat.InfrastructureAnalyzer;
import org.apache.sysml.runtime.util.ProgramConverter;
import org.apache.sysml.runtime.util.UtilFunctions;
import scala.Tuple2;

public class RemoteParForSparkWorker
extends ParWorker
implements PairFlatMapFunction<Task, Long, String> {
    private static final long serialVersionUID = -3254950138084272296L;
    private static final CachedReuseVariables reuseVars = new CachedReuseVariables();
    private final long _jobid;
    private final String _prog;
    private final HashMap<String, byte[]> _clsMap;
    private boolean _initialized = false;
    private boolean _caching = true;
    private final boolean _cleanCache;
    private final LongAccumulator _aTasks;
    private final LongAccumulator _aIters;
    private final Map<String, Broadcast<CacheBlock>> _brInputs;

    public RemoteParForSparkWorker(long jobid, String program, HashMap<String, byte[]> clsMap, boolean cpCaching, LongAccumulator atasks, LongAccumulator aiters, Map<String, Broadcast<CacheBlock>> brInputs, boolean cleanCache) {
        this._jobid = jobid;
        this._prog = program;
        this._clsMap = clsMap;
        this._initialized = false;
        this._caching = cpCaching;
        this._aTasks = atasks;
        this._aIters = aiters;
        this._brInputs = brInputs;
        this._cleanCache = cleanCache;
    }

    public Iterator<Tuple2<Long, String>> call(Task arg0) throws Exception {
        if (!this._initialized) {
            this.configureWorker(TaskContext.get().taskAttemptId());
        }
        HashSet<String> inVars = new HashSet<String>(this._ec.getVariables().keySet());
        long numIter = this.getExecutedIterations();
        super.executeTask(arg0);
        this._aTasks.add(1L);
        this._aIters.add((long)((int)(this.getExecutedIterations() - numIter)));
        this._ec.getVariables().keySet().stream().filter(v -> !inVars.contains(v)).map(v -> this._ec.getVariable((String)v)).filter(d -> d instanceof CacheableData).forEach(c -> ((CacheableData)c).freeEvictedBlob());
        return RemoteParForUtils.exportResultVariables(this._workerID, this._ec.getVariables(), this._resultVars).stream().map(s -> new Tuple2((Object)this._workerID, s)).iterator();
    }

    private void configureWorker(long taskID) throws IOException {
        this._workerID = taskID;
        for (Map.Entry<String, byte[]> e : this._clsMap.entrySet()) {
            CodegenUtils.getClassSync(e.getKey(), e.getValue());
        }
        ParForBody body = ProgramConverter.parseParForBody(this._prog, (int)this._workerID, true);
        this._childBlocks = body.getChildBlocks();
        this._ec = body.getEc();
        this._resultVars = body.getResultVariables();
        this._numTasks = 0L;
        this._numIters = 0L;
        Set<String> blacklist = UtilFunctions.asSet(new List[]{this._resultVars.stream().map(v -> v._name).collect(Collectors.toList()), this._ec.getVarListPartitioned()});
        reuseVars.reuseVariables(this._jobid, this._ec.getVariables(), blacklist, this._brInputs, this._cleanCache);
        RemoteParForUtils.setupBufferPool(this._workerID);
        super.pinResultVariables();
        if (!this._caching && !InfrastructureAnalyzer.isLocalMode()) {
            CacheableData.disableCaching();
        }
        this._initialized = true;
    }

    public static void cleanupCachedVariables(long pfid) {
        reuseVars.clearVariables(pfid);
    }
}

