/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.hops.codegen.template;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.sysml.hops.Hop;
import org.apache.sysml.hops.codegen.cplan.CNodeTpl;
import org.apache.sysml.hops.codegen.template.CPlanMemoTable;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.util.UtilFunctions;

public abstract class TemplateBase {
    protected final TemplateType _type;
    protected final CloseType _ctype;

    protected TemplateBase(TemplateType type) {
        this(type, CloseType.OPEN_VALID);
    }

    protected TemplateBase(TemplateType type, CloseType ctype) {
        this._type = type;
        this._ctype = ctype;
    }

    public TemplateType getType() {
        return this._type;
    }

    public CloseType getCType() {
        return this._ctype;
    }

    public boolean isClosed() {
        return this._ctype.isClosed();
    }

    public int hashCode() {
        return UtilFunctions.intHashCode(this._type.ordinal(), this._ctype.ordinal());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TemplateBase)) {
            return false;
        }
        TemplateBase that = (TemplateBase)obj;
        return this._type == that._type && this._ctype == that._ctype;
    }

    public abstract boolean open(Hop var1);

    public abstract boolean fuse(Hop var1, Hop var2);

    public abstract boolean merge(Hop var1, Hop var2);

    public abstract CloseType close(Hop var1);

    public abstract Pair<Hop[], CNodeTpl> constructCplan(Hop var1, CPlanMemoTable var2, boolean var3);

    public static enum CloseType {
        CLOSED_VALID,
        CLOSED_INVALID,
        OPEN_VALID,
        OPEN_INVALID;


        public boolean isClosed() {
            return this == CLOSED_VALID || this == CLOSED_INVALID;
        }

        public boolean isValid() {
            return this == CLOSED_VALID || this == OPEN_VALID;
        }
    }

    public static enum TemplateType {
        MAGG,
        OUTER,
        ROW,
        CELL;


        public int getRank() {
            return this.ordinal();
        }

        public boolean isIn(TemplateType ... types) {
            return ArrayUtils.contains((Object[])types, (Object)((Object)this));
        }
    }
}

