/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.BinaryCPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPInstruction;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.matrix.data.LibCommonsMath;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.operators.BinaryOperator;
import org.apache.sysml.runtime.matrix.operators.Operator;

public class BinaryMatrixMatrixCPInstruction
extends BinaryCPInstruction {
    protected BinaryMatrixMatrixCPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(CPInstruction.CPType.Binary, op, in1, in2, out, opcode, istr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        if (LibCommonsMath.isSupportedMatrixMatrixOperation(this.getOpcode())) {
            MatrixBlock solution = LibCommonsMath.matrixMatrixOperations(ec.getMatrixInput(this.input1.getName()), ec.getMatrixInput(this.input2.getName()), this.getOpcode());
            ec.setMatrixOutput(this.output.getName(), solution, this.getExtendedOpcode());
            ec.releaseMatrixInput(this.input1.getName());
            ec.releaseMatrixInput(this.input2.getName());
            return;
        }
        MatrixBlock inBlock1 = ec.getMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        MatrixBlock inBlock2 = ec.getMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        BinaryOperator bop = (BinaryOperator)this._optr;
        MatrixBlock retBlock = (MatrixBlock)inBlock1.binaryOperations(bop, inBlock2, new MatrixBlock());
        ec.releaseMatrixInput(this.input1.getName(), this.getExtendedOpcode());
        ec.releaseMatrixInput(this.input2.getName(), this.getExtendedOpcode());
        if (this.checkGuardedRepresentationChange(inBlock1, inBlock2, retBlock)) {
            retBlock.examSparsity();
        }
        ec.setMatrixOutput(this.output.getName(), retBlock, this.getExtendedOpcode());
    }
}

