/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.core.axis2;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.util.UIDGenerator;
import org.apache.axiom.util.blob.OverflowBlob;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.InOutAxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.SynapseException;
import org.apache.synapse.aspects.statistics.StatisticsCollector;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.endpoints.EndpointDefinition;
import org.apache.synapse.endpoints.dispatch.Dispatcher;
import org.apache.synapse.mediators.MediatorFaultHandler;
import org.apache.synapse.mediators.MediatorWorker;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.rest.RESTRequestHandler;
import org.apache.synapse.task.SynapseTaskManager;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.apache.synapse.util.concurrent.SynapseThreadPool;
import org.apache.synapse.util.xpath.ext.SynapseXpathFunctionContextProvider;
import org.apache.synapse.util.xpath.ext.SynapseXpathVariableResolver;

public class Axis2SynapseEnvironment
implements SynapseEnvironment {
    private static final Log log = LogFactory.getLog(Axis2SynapseEnvironment.class);
    private SynapseConfiguration synapseConfig;
    private ConfigurationContext configContext;
    private ExecutorService executorService;
    private boolean initialized = false;
    private SynapseTaskManager taskManager;
    private RESTRequestHandler restHandler;
    private StatisticsCollector statisticsCollector = new StatisticsCollector();
    private ServerContextInformation contextInformation;
    Map<QName, SynapseXpathFunctionContextProvider> xpathFunctionExtensions = new HashMap<QName, SynapseXpathFunctionContextProvider>();
    Map<QName, SynapseXpathVariableResolver> xpathVariableExtensions = new HashMap<QName, SynapseXpathVariableResolver>();
    private boolean synapseDebugMode;

    public Axis2SynapseEnvironment(SynapseConfiguration synCfg) {
        int coreThreads = 20;
        int maxThreads = 100;
        long keepAlive = 5L;
        int qLength = -1;
        try {
            qLength = Integer.parseInt(synCfg.getProperty("synapse.threads.qlen"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            coreThreads = Integer.parseInt(synCfg.getProperty("synapse.threads.core"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            maxThreads = Integer.parseInt(synCfg.getProperty("synapse.threads.max"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            keepAlive = Long.parseLong(synCfg.getProperty("synapse.threads.keepalive"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.executorService = new SynapseThreadPool(coreThreads, maxThreads, keepAlive, qLength, synCfg.getProperty("synapse.threads.group", "synapse-thread-group"), synCfg.getProperty("synapse.threads.idprefix", "SynapseWorker"));
        this.taskManager = new SynapseTaskManager();
        this.restHandler = new RESTRequestHandler();
    }

    public Axis2SynapseEnvironment(ConfigurationContext cfgCtx, SynapseConfiguration synapseConfig) {
        this(synapseConfig);
        this.configContext = cfgCtx;
        this.synapseConfig = synapseConfig;
    }

    public Axis2SynapseEnvironment(ConfigurationContext cfgCtx, SynapseConfiguration synapseConfig, ServerContextInformation contextInformation) {
        this(cfgCtx, synapseConfig);
        this.contextInformation = contextInformation;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean injectMessage(MessageContext synCtx) {
        String proxyName;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Injecting MessageContext");
        }
        synCtx.setEnvironment(this);
        Mediator mandatorySeq = synCtx.getConfiguration().getMandatorySequence();
        if (mandatorySeq != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Start mediating the message in the pre-mediate state using the mandatory sequence");
            }
            if (!mandatorySeq.mediate(synCtx)) {
                if (!log.isDebugEnabled()) return false;
                log.debug((Object)((synCtx.isResponse() ? "Response" : "Request") + " message for the " + (synCtx.getProperty("proxy.name") != null ? "proxy service " + synCtx.getProperty("proxy.name") : "message mediation") + " dropped in the pre-mediation state by the mandatory sequence : \n" + synCtx));
                return false;
            }
        }
        String receivingSequence = (String)synCtx.getProperty("RECEIVING_SEQUENCE");
        Set keySet = synCtx.getPropertyKeySet();
        if (keySet != null) {
            keySet.remove("RECEIVING_SEQUENCE");
        }
        if ((proxyName = (String)synCtx.getProperty("proxy.name")) == null || "".equals(proxyName)) {
            synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
            if (receivingSequence != null) {
                Mediator seqMediator;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using Sequence with name: " + receivingSequence + " for injected message"));
                }
                if ((seqMediator = synCtx.getSequence(receivingSequence)) != null) {
                    return seqMediator.mediate(synCtx);
                }
                log.warn((Object)("Cannot find a Sequence with name: " + receivingSequence + " for injecting the response message"));
                return false;
            }
            boolean processed = this.restHandler.process(synCtx);
            if (processed) {
                return true;
            }
            if (!log.isDebugEnabled()) return synCtx.getMainSequence().mediate(synCtx);
            log.debug((Object)"Using Main Sequence for injected message");
            return synCtx.getMainSequence().mediate(synCtx);
        }
        ProxyService proxyService = synCtx.getConfiguration().getProxyService(proxyName);
        if (proxyService == null) return true;
        if (proxyService.getTargetFaultSequence() != null) {
            Mediator faultSequence = synCtx.getSequence(proxyService.getTargetFaultSequence());
            if (faultSequence != null) {
                synCtx.pushFaultHandler(new MediatorFaultHandler(faultSequence));
            } else {
                log.warn((Object)("Cloud not find any fault-sequence named :" + proxyService.getTargetFaultSequence() + "; Setting the default fault sequence for out path"));
                synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
            }
        } else if (proxyService.getTargetInLineFaultSequence() != null) {
            synCtx.pushFaultHandler(new MediatorFaultHandler(proxyService.getTargetInLineFaultSequence()));
        } else {
            synCtx.pushFaultHandler(new MediatorFaultHandler(synCtx.getFaultSequence()));
        }
        Mediator outSequence = this.getProxyOutSequence(synCtx, proxyService);
        if (receivingSequence != null) {
            Mediator seqMediator;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using Sequence with name: " + receivingSequence + " for injected message"));
            }
            if ((seqMediator = synCtx.getSequence(receivingSequence)) != null) {
                seqMediator.mediate(synCtx);
                return true;
            }
            log.warn((Object)("Cannot find a Sequence with name: " + receivingSequence + " for injecting the message"));
            return false;
        }
        if (outSequence != null) {
            outSequence.mediate(synCtx);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(proxyService + " does not specifies an out-sequence - sending the response back"));
        }
        Axis2Sender.sendBack(synCtx);
        return true;
    }

    @Override
    public void injectAsync(MessageContext synCtx, SequenceMediator seq) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Injecting MessageContext for asynchronous mediation using the : " + (seq.getName() == null ? "Anonymous" : seq.getName()) + " Sequence"));
        }
        synCtx.setEnvironment(this);
        this.executorService.execute(new MediatorWorker(seq, synCtx));
    }

    @Override
    public void send(EndpointDefinition endpoint, MessageContext synCtx) {
        if (synCtx.isResponse()) {
            if (endpoint != null) {
                if (this.isTransportSwitching(synCtx, endpoint)) {
                    this.buildMessage(synCtx);
                }
                Axis2Sender.sendOn(endpoint, synCtx);
            } else {
                ProxyService proxyService;
                String proxyName = (String)synCtx.getProperty("proxy.name");
                if (proxyName != null && (proxyService = this.synapseConfig.getProxyService(proxyName)).isModuleEngaged()) {
                    this.buildMessage(synCtx);
                }
                Axis2Sender.sendBack(synCtx);
            }
        } else {
            Dispatcher dispatcher = (Dispatcher)synCtx.getProperty("synape.sal.endpoints.dispatcher");
            if (dispatcher != null && !dispatcher.isServerInitiatedSession()) {
                dispatcher.updateSession(synCtx);
            }
            synCtx.setProperty("synapse.internal.request.sending", true);
            if (endpoint == null || this.isTransportSwitching(synCtx, endpoint)) {
                this.buildMessage(synCtx);
            }
            Axis2Sender.sendOn(endpoint, synCtx);
        }
    }

    private boolean isTransportSwitching(MessageContext synCtx, EndpointDefinition endpoint) {
        if (endpoint.getAddress() != null) {
            return !endpoint.getAddress().startsWith("http");
        }
        String address = synCtx.getTo().getAddress();
        if (address != null) {
            return !address.startsWith("http");
        }
        return false;
    }

    private void buildMessage(MessageContext synCtx) {
        try {
            RelayUtils.buildMessage((org.apache.axis2.context.MessageContext)((Axis2MessageContext)synCtx).getAxis2MessageContext(), (boolean)false);
        }
        catch (Exception e) {
            this.handleException("Error while building message", e);
        }
    }

    @Override
    public MessageContext createMessageContext() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Creating Message Context");
        }
        org.apache.axis2.context.MessageContext axis2MC = new org.apache.axis2.context.MessageContext();
        axis2MC.setConfigurationContext(this.configContext);
        ServiceContext svcCtx = new ServiceContext();
        OperationContext opCtx = new OperationContext((AxisOperation)new InOutAxisOperation(), svcCtx);
        axis2MC.setServiceContext(svcCtx);
        axis2MC.setOperationContext(opCtx);
        Axis2MessageContext mc = new Axis2MessageContext(axis2MC, this.synapseConfig, this);
        mc.setMessageID(UIDGenerator.generateURNString());
        try {
            mc.setEnvelope(OMAbstractFactory.getSOAP12Factory().createSOAPEnvelope());
            mc.getEnvelope().addChild((OMNode)OMAbstractFactory.getSOAP12Factory().createSOAPBody());
        }
        catch (Exception e) {
            this.handleException("Unable to attach the SOAP envelope to the created new message context", e);
        }
        return mc;
    }

    @Override
    public OverflowBlob createOverflowBlob() {
        String chkSize = this.synapseConfig.getProperty("synapse.temp_data.chunk.size");
        String chunkNumber = this.synapseConfig.getProperty("synapse.temp_data.chunk.threshold");
        int numberOfChunks = 8;
        int chunkSize = 1024;
        if (chkSize != null) {
            chunkSize = Integer.parseInt(chkSize);
        }
        if (chunkNumber != null) {
            numberOfChunks = Integer.parseInt(chunkNumber);
        }
        String tempPrefix = this.synapseConfig.getProperty("synapse.tempfile.prefix", "tmp_");
        String tempSuffix = this.synapseConfig.getProperty("synapse.tempfile.sufix", ".dat");
        return new OverflowBlob(numberOfChunks, chunkSize, tempPrefix, tempSuffix);
    }

    @Override
    public StatisticsCollector getStatisticsCollector() {
        return this.statisticsCollector;
    }

    @Override
    @Deprecated
    public void setStatisticsCollector(StatisticsCollector collector) {
        this.statisticsCollector = collector;
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean state) {
        this.initialized = state;
    }

    @Override
    public SynapseConfiguration getSynapseConfiguration() {
        return this.synapseConfig;
    }

    @Override
    public SynapseTaskManager getTaskManager() {
        return this.taskManager;
    }

    @Override
    public ServerContextInformation getServerContextInformation() {
        return this.contextInformation;
    }

    public ConfigurationContext getAxis2ConfigurationContext() {
        return this.configContext;
    }

    @Override
    public Map<QName, SynapseXpathFunctionContextProvider> getXpathFunctionExtensions() {
        return this.xpathFunctionExtensions;
    }

    @Override
    public Map<QName, SynapseXpathVariableResolver> getXpathVariableExtensions() {
        return this.xpathVariableExtensions;
    }

    public void setXpathFunctionExtensions(SynapseXpathFunctionContextProvider functionExt) {
        if (functionExt != null) {
            this.xpathFunctionExtensions.put(functionExt.getResolvingQName(), functionExt);
        }
    }

    public void setXpathVariableExtensions(SynapseXpathVariableResolver variableExt) {
        if (variableExt != null) {
            this.xpathVariableExtensions.put(variableExt.getResolvingQName(), variableExt);
        }
    }

    @Override
    public boolean isSynapseDebugMode() {
        return this.synapseDebugMode;
    }

    private void handleException(String message, Throwable e) {
        log.error((Object)message, e);
        throw new SynapseException(message, e);
    }

    private Mediator getProxyOutSequence(MessageContext synCtx, ProxyService proxyService) {
        String sequenceName = proxyService.getTargetOutSequence();
        if (sequenceName != null && !"".equals(sequenceName)) {
            Mediator outSequence = synCtx.getSequence(sequenceName);
            if (outSequence != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using the sequence named " + sequenceName + " for the outgoing message mediation of the proxy service " + proxyService));
                }
                return outSequence;
            }
            log.error((Object)("Unable to find the out-sequence specified by the name " + sequenceName));
            throw new SynapseException("Unable to find the out-sequence specified by the name " + sequenceName);
        }
        SequenceMediator outSequence = proxyService.getTargetInLineOutSequence();
        if (outSequence != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using the anonymous out-sequence specified in the proxy service " + proxyService + " for outgoing message mediation"));
            }
            return outSequence;
        }
        return null;
    }

    public void setSynapseDebugMode(boolean synapseDebugMode) {
        this.synapseDebugMode = synapseDebugMode;
    }
}

