/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru.util;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.util.AXIOMUtil;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.util.RelayUtils;

public class RelaySecurityMessageBuilderDispatchHandler
extends AbstractDispatcher {
    private static final Log log = LogFactory.getLog(RelaySecurityMessageBuilderDispatchHandler.class);
    private static final String APPLICATION_XML = "application/xml";
    private static final String WSSE = "wsse";
    private static final String WSS_WSSECURITY_SECEXT_1_0_XSD = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    private static final String PROXY = "proxy";
    private static final String SERVICE_TYPE = "serviceType";
    public static final String NAME = "RelaySecurityMessageBuilderDispatchHandler";

    public Handler.InvocationResponse invoke(MessageContext messageContext) throws AxisFault {
        Handler.InvocationResponse invocationResponse = super.invoke(messageContext);
        EndpointReference toEPR = messageContext.getTo();
        Pipe pipe = (Pipe)messageContext.getProperty("pass-through.pipe");
        if (pipe != null) {
            if (toEPR != null) {
                ConfigurationContext configurationContext = messageContext.getConfigurationContext();
                AxisConfiguration registry = configurationContext.getAxisConfiguration();
                String filePart = toEPR.getAddress();
                if (filePart != null) {
                    AxisService axisService;
                    String serviceOpPart = Utils.getServiceAndOperationPart((String)filePart, (String)messageContext.getConfigurationContext().getServiceContextPath());
                    if (messageContext.getConfigurationContext().getServiceContextPath() != null && serviceOpPart != null && (axisService = registry.getService(serviceOpPart)) != null) {
                        Parameter parameter = axisService.getParameter(SERVICE_TYPE);
                        if (parameter != null) {
                            if (!parameter.getValue().equals(PROXY)) {
                                this.build(messageContext);
                            }
                        } else {
                            this.build(messageContext);
                        }
                    }
                }
            }
            if (messageContext.isEngaged("rampart")) {
                SOAPHeader header = null;
                if (messageContext.getEnvelope().getHeader() != null) {
                    header = messageContext.getEnvelope().getHeader();
                }
                this.build(messageContext);
                this.handlePOXRequests(messageContext, header);
            }
        }
        return invocationResponse;
    }

    private void handlePOXRequests(MessageContext messageContext, SOAPHeader header) {
        int j;
        String contentType;
        String _contentType = contentType = (String)messageContext.getProperty("ContentType");
        if (contentType != null && (j = contentType.indexOf(";")) > 0) {
            _contentType = contentType.substring(0, j);
        }
        if (_contentType != null && _contentType.equals(APPLICATION_XML) && header != null && header.getChildElements() != null || messageContext.isDoingREST()) {
            try {
                OMElement element = AXIOMUtil.stringToOM((String)header.toString());
                OMNamespace omNamespace = OMAbstractFactory.getOMFactory().createOMNamespace(WSS_WSSECURITY_SECEXT_1_0_XSD, WSSE);
                SOAPHeaderBlock soapBlockingHeader = OMAbstractFactory.getSOAP12Factory().createSOAPHeaderBlock("Security", omNamespace);
                OMElement securityHeader = (OMElement)element.getFirstOMChild();
                if (securityHeader != null) {
                    while (securityHeader.getChildElements().hasNext()) {
                        soapBlockingHeader.addChild((OMNode)securityHeader.getChildElements().next());
                    }
                    messageContext.getEnvelope().getHeader().addChild((OMNode)soapBlockingHeader);
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while executing the message at relaySecurity handler", (Throwable)e);
            }
        }
    }

    private void build(MessageContext messageContext) {
        try {
            RelayUtils.buildMessage(messageContext, false);
        }
        catch (Exception e) {
            log.error((Object)"Error while executing the message at relaySecurity handler", (Throwable)e);
        }
    }

    public AxisOperation findOperation(AxisService arg0, MessageContext arg1) throws AxisFault {
        return null;
    }

    public AxisService findService(MessageContext arg0) throws AxisFault {
        return null;
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }
}

