/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.passthru;

import org.apache.axis2.context.MessageContext;
import org.apache.http.nio.NHttpConnection;
import org.apache.synapse.transport.passthru.Pipe;
import org.apache.synapse.transport.passthru.ProtocolState;
import org.apache.synapse.transport.passthru.TargetRequest;
import org.apache.synapse.transport.passthru.TargetResponse;
import org.apache.synapse.transport.passthru.config.TargetConfiguration;
import org.apache.synapse.transport.passthru.util.ControlledByteBuffer;

public class TargetContext {
    private TargetConfiguration targetConfiguration = null;
    public static final String CONNECTION_INFORMATION = "CONNECTION_INFORMATION";
    private TargetRequest request;
    private TargetResponse response;
    private ProtocolState state;
    private MessageContext requestMsgCtx;
    private Pipe reader;
    private Pipe writer;

    public TargetContext(TargetConfiguration targetConfiguration) {
        this.targetConfiguration = targetConfiguration;
    }

    public ProtocolState getState() {
        return this.state;
    }

    public void setState(ProtocolState state) {
        this.state = state;
    }

    public TargetRequest getRequest() {
        return this.request;
    }

    public void setRequest(TargetRequest request) {
        this.request = request;
    }

    public TargetResponse getResponse() {
        return this.response;
    }

    public void setResponse(TargetResponse response) {
        this.response = response;
    }

    public MessageContext getRequestMsgCtx() {
        return this.requestMsgCtx;
    }

    public void setRequestMsgCtx(MessageContext requestMsgCtx) {
        this.requestMsgCtx = requestMsgCtx;
    }

    public Pipe getReader() {
        return this.reader;
    }

    public Pipe getWriter() {
        return this.writer;
    }

    public void setReader(Pipe reader) {
        this.reader = reader;
    }

    public void setWriter(Pipe writer) {
        this.writer = writer;
    }

    public void reset() {
        this.reset(false);
    }

    public void reset(boolean isError) {
        this.request = null;
        this.response = null;
        if (this.state != ProtocolState.CLOSED) {
            this.state = ProtocolState.REQUEST_READY;
        }
        if (this.writer != null && !isError) {
            ControlledByteBuffer buffer = this.writer.getBuffer();
            buffer.clear();
            this.targetConfiguration.getBufferFactory().release(buffer);
        }
        this.reader = null;
        this.writer = null;
    }

    public static void create(NHttpConnection conn, ProtocolState state, TargetConfiguration configuration) {
        TargetContext info = new TargetContext(configuration);
        conn.getContext().setAttribute(CONNECTION_INFORMATION, (Object)info);
        info.setState(state);
    }

    public static void updateState(NHttpConnection conn, ProtocolState state) {
        TargetContext info = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        if (info == null) {
            throw new IllegalStateException("Connection information should be present");
        }
        info.setState(state);
    }

    public static ProtocolState getState(NHttpConnection conn) {
        TargetContext info = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getState() : null;
    }

    public static void setRequest(NHttpConnection conn, TargetRequest request) {
        TargetContext info = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        if (info == null) {
            throw new IllegalStateException("Connection information should be present");
        }
        info.setRequest(request);
    }

    public static void setResponse(NHttpConnection conn, TargetResponse response) {
        TargetContext info = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        if (info == null) {
            throw new IllegalStateException("Connection information should be present");
        }
        info.setResponse(response);
    }

    public static TargetRequest getRequest(NHttpConnection conn) {
        TargetContext info = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getRequest() : null;
    }

    public static TargetResponse getResponse(NHttpConnection conn) {
        TargetContext info = (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
        return info != null ? info.getResponse() : null;
    }

    public static TargetContext get(NHttpConnection conn) {
        return (TargetContext)conn.getContext().getAttribute(CONNECTION_INFORMATION);
    }
}

