/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.caching.transport;

import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.caching.CachingException;
import org.wso2.caching.transport.TransportProcessor;

public class TransportProcessorFactory {
    private static final Log log = LogFactory.getLog(TransportProcessorFactory.class);

    public static TransportProcessor getInTransportProcessor(MessageContext msgCtx) throws CachingException {
        return TransportProcessorFactory.getTransportProcessor(msgCtx.getTransportIn().getName());
    }

    public static TransportProcessor getOutTransportProcessor(MessageContext msgCtx) throws CachingException {
        return TransportProcessorFactory.getTransportProcessor(msgCtx.getTransportOut().getName());
    }

    private static TransportProcessor getTransportProcessor(String transport) throws CachingException {
        TransportProcessor processor = null;
        String className = transport.toUpperCase() + "TransportProcessor";
        Class clazz = TransportProcessor.class;
        try {
            clazz = Class.forName(className);
            Object o = clazz.newInstance();
            if (o instanceof TransportProcessor) {
                processor = (TransportProcessor)o;
            }
        }
        catch (ClassNotFoundException e) {
            TransportProcessorFactory.handleException("Unable to find the transport processor for the transport " + transport, e);
        }
        catch (IllegalAccessException e) {
            TransportProcessorFactory.handleException("Unable to instantiate the transport processor " + clazz, e);
        }
        catch (InstantiationException e) {
            TransportProcessorFactory.handleException("Unable to instantiate the transport processor " + className, e);
        }
        return processor;
    }

    private static void handleException(String message, Throwable e) throws CachingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)message, e);
        }
        throw new CachingException(message, e);
    }
}

