/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.securevault;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.securevault.SecureVaultException;
import org.apache.synapse.securevault.secret.SecretCallback;
import org.apache.synapse.securevault.secret.SecretCallbackHandler;
import org.apache.synapse.securevault.secret.SecretLoadingModule;
import org.apache.synapse.securevault.secret.SingleSecretCallback;

public class SecretResolver {
    private static Log log = LogFactory.getLog(SecretResolver.class);
    private boolean initialized = false;
    private final ArrayList<String> protectedTokens = new ArrayList();
    private SecretLoadingModule secretLoadingModule;
    private static final String DEFAULT_PROMPT = "password > ";

    public void init(SecretCallbackHandler secretCallbackHandler) {
        if (this.initialized) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"SecretResolver already has been started.");
            }
            return;
        }
        if (secretCallbackHandler == null) {
            throw new SecureVaultException("SecretResolver cannot be initialized. The provided SecretCallbackHandler is null", log);
        }
        this.secretLoadingModule = new SecretLoadingModule();
        this.secretLoadingModule.init(new SecretCallbackHandler[]{secretCallbackHandler});
        this.initialized = true;
    }

    public String resolve(String encryptedPassword) {
        return this.resolve(encryptedPassword, DEFAULT_PROMPT);
    }

    public String resolve(String encryptedPassword, String prompt) {
        this.assertInitialized();
        if (encryptedPassword == null || "".equals(encryptedPassword)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Given Encrypted Password is empty or null. Returning itself");
            }
            return encryptedPassword;
        }
        SingleSecretCallback secretCallback = new SingleSecretCallback(encryptedPassword);
        secretCallback.setPrompt(prompt);
        this.secretLoadingModule.load(new SecretCallback[]{secretCallback});
        String plainText = secretCallback.getSecret();
        return plainText;
    }

    public void addProtectedToken(String token) {
        this.assertInitialized();
        if (token != null && !"".equals(token)) {
            this.protectedTokens.add(token.trim());
        }
    }

    public boolean isTokenProtected(String token) {
        this.assertInitialized();
        return token != null && !"".equals(token) && this.protectedTokens.contains(token.trim());
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    private void assertInitialized() {
        if (!this.initialized) {
            throw new SecureVaultException("SecretResolver has not been initialized, it requires to be initialized, with the required configurations before starting", log);
        }
    }

    public void shutDown() {
        this.initialized = false;
        this.secretLoadingModule = null;
        this.protectedTokens.clear();
    }
}

