/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.base;

import java.util.Map;
import org.apache.axis2.transport.TransportListener;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.base.ManagementSupport;
import org.apache.axis2.transport.base.TransportViewMBean;

public class TransportView
implements TransportViewMBean {
    private ManagementSupport managementSupport = null;
    private TransportListener listener = null;
    private TransportSender sender = null;

    public TransportView(TransportListener listener, TransportSender sender) {
        if (listener != null) {
            this.listener = listener;
            if (listener instanceof ManagementSupport) {
                this.managementSupport = (ManagementSupport)listener;
            }
        }
        if (sender != null) {
            this.sender = sender;
            if (sender instanceof ManagementSupport) {
                this.managementSupport = (ManagementSupport)sender;
            }
        }
    }

    public long getMessagesReceived() {
        if (this.managementSupport != null) {
            return this.managementSupport.getMessagesReceived();
        }
        return -1L;
    }

    public long getFaultsReceiving() {
        if (this.managementSupport != null) {
            return this.managementSupport.getFaultsReceiving();
        }
        return -1L;
    }

    public long getTimeoutsReceiving() {
        if (this.managementSupport != null) {
            return this.managementSupport.getTimeoutsReceiving();
        }
        return -1L;
    }

    public long getTimeoutsSending() {
        if (this.managementSupport != null) {
            this.managementSupport.getTimeoutsSending();
        }
        return -1L;
    }

    public long getBytesReceived() {
        if (this.managementSupport != null) {
            return this.managementSupport.getBytesReceived();
        }
        return -1L;
    }

    public long getMessagesSent() {
        if (this.managementSupport != null) {
            return this.managementSupport.getMessagesSent();
        }
        return -1L;
    }

    public long getFaultsSending() {
        if (this.managementSupport != null) {
            return this.managementSupport.getFaultsSending();
        }
        return -1L;
    }

    public long getBytesSent() {
        if (this.managementSupport != null) {
            return this.managementSupport.getBytesSent();
        }
        return -1L;
    }

    public long getMinSizeReceived() {
        if (this.managementSupport != null) {
            return this.managementSupport.getMinSizeReceived();
        }
        return -1L;
    }

    public long getMaxSizeReceived() {
        if (this.managementSupport != null) {
            return this.managementSupport.getMaxSizeReceived();
        }
        return -1L;
    }

    public double getAvgSizeReceived() {
        if (this.managementSupport != null) {
            return this.managementSupport.getAvgSizeReceived();
        }
        return -1.0;
    }

    public long getMinSizeSent() {
        if (this.managementSupport != null) {
            return this.managementSupport.getMinSizeSent();
        }
        return -1L;
    }

    public long getMaxSizeSent() {
        if (this.managementSupport != null) {
            return this.managementSupport.getMaxSizeSent();
        }
        return -1L;
    }

    public double getAvgSizeSent() {
        if (this.managementSupport != null) {
            return this.managementSupport.getAvgSizeSent();
        }
        return -1.0;
    }

    public Map getResponseCodeTable() {
        if (this.managementSupport != null) {
            return this.managementSupport.getResponseCodeTable();
        }
        return null;
    }

    public int getActiveThreadCount() {
        if (this.managementSupport != null) {
            return this.managementSupport.getActiveThreadCount();
        }
        return -1;
    }

    public int getQueueSize() {
        if (this.managementSupport != null) {
            return this.managementSupport.getQueueSize();
        }
        return -1;
    }

    public void start() throws Exception {
        if (this.listener != null) {
            this.listener.start();
        }
    }

    public void stop() throws Exception {
        if (this.listener != null) {
            this.listener.stop();
        } else if (this.sender != null) {
            this.sender.stop();
        }
    }

    public void pause() throws Exception {
        if (this.managementSupport != null) {
            this.managementSupport.pause();
        }
    }

    public void resume() throws Exception {
        if (this.managementSupport != null) {
            this.managementSupport.resume();
        }
    }

    public void maintenenceShutdown(long seconds) throws Exception {
        if (this.managementSupport != null) {
            this.managementSupport.maintenenceShutdown(seconds * 1000L);
        }
    }

    public void resetStatistics() {
        if (this.managementSupport != null) {
            this.managementSupport.resetStatistics();
        }
    }

    public long getLastResetTime() {
        if (this.managementSupport != null) {
            return this.managementSupport.getLastResetTime();
        }
        return -1L;
    }

    public long getMetricsWindow() {
        if (this.managementSupport != null) {
            return System.currentTimeMillis() - this.managementSupport.getLastResetTime();
        }
        return -1L;
    }
}

