/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.SocketException;
import java.util.Properties;
import org.apache.axis2.clustering.Member;
import org.apache.axis2.clustering.tribes.MembershipManager;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.Utils;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TribesUtil {
    private static Log log = LogFactory.getLog(TribesUtil.class);

    public static void printMembers(MembershipManager membershipManager) {
        org.apache.catalina.tribes.Member[] members = membershipManager.getMembers();
        if (members != null) {
            int length = members.length;
            if (length > 0) {
                log.info((Object)"Members of current cluster");
                for (int i = 0; i < length; ++i) {
                    log.info((Object)("Member" + (i + 1) + " " + TribesUtil.getName(members[i])));
                }
            } else {
                log.info((Object)"No members in current cluster");
            }
        }
    }

    public static String getName(org.apache.catalina.tribes.Member member) {
        return TribesUtil.getHost(member) + ":" + member.getPort() + "(" + new String(member.getDomain()) + ")";
    }

    public static String getHost(org.apache.catalina.tribes.Member member) {
        byte[] hostBytes = member.getHost();
        StringBuffer host = new StringBuffer();
        if (hostBytes != null) {
            for (int i = 0; i < hostBytes.length; ++i) {
                int hostByte = hostBytes[i] >= 0 ? hostBytes[i] : hostBytes[i] + 256;
                host.append(hostByte);
                if (i >= hostBytes.length - 1) continue;
                host.append(".");
            }
        }
        return host.toString();
    }

    public static String getLocalHost(Channel channel) {
        return TribesUtil.getName(channel.getLocalMember(true));
    }

    public static String getLocalHost(Parameter tcpListenHost) {
        String host = null;
        if (tcpListenHost != null) {
            host = ((String)tcpListenHost.getValue()).trim();
        } else {
            try {
                host = Utils.getIpAddress();
            }
            catch (SocketException e) {
                String msg = "Could not get local IP address";
                log.error((Object)msg, (Throwable)e);
            }
        }
        if (System.getProperty("axis2.local.ip.address") != null) {
            host = System.getProperty("axis2.local.ip.address");
        }
        return host;
    }

    public static byte[] getRpcMembershipChannelId(byte[] domain) {
        return (new String(domain) + ":" + "rpc.membership.channel").getBytes();
    }

    public static byte[] getRpcInitChannelId(byte[] domain) {
        return (new String(domain) + ":" + "rpc.init.channel").getBytes();
    }

    public static byte[] getRpcMessagingChannelId(byte[] domain) {
        return (new String(domain) + ":" + "rpc.msg.channel").getBytes();
    }

    public static boolean isInDomain(org.apache.catalina.tribes.Member member, byte[] domain) {
        return Arrays.equals((byte[])domain, (byte[])member.getDomain());
    }

    public static boolean areInSameDomain(org.apache.catalina.tribes.Member member1, org.apache.catalina.tribes.Member member2) {
        return Arrays.equals((byte[])member1.getDomain(), (byte[])member2.getDomain());
    }

    public static Member toAxis2Member(org.apache.catalina.tribes.Member member) {
        String isActive;
        String httpsPort;
        Member axis2Member = new Member(TribesUtil.getHost(member), member.getPort());
        Properties props = TribesUtil.getProperties(member.getPayload());
        String httpPort = props.getProperty("httpPort");
        if (httpPort != null && httpPort.trim().length() != 0) {
            axis2Member.setHttpPort(Integer.parseInt(httpPort));
        }
        if ((httpsPort = props.getProperty("httpsPort")) != null && httpsPort.trim().length() != 0) {
            axis2Member.setHttpsPort(Integer.parseInt(httpsPort));
        }
        if ((isActive = props.getProperty("isActive")) != null && isActive.trim().length() != 0) {
            axis2Member.setActive(Boolean.valueOf(isActive).booleanValue());
        }
        axis2Member.setDomain(new String(member.getDomain()));
        axis2Member.setProperties(props);
        return axis2Member;
    }

    private static Properties getProperties(byte[] payload) {
        Properties props = null;
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(payload);
            props = new Properties();
            props.load(bin);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return props;
    }
}

