/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp.connectionfactory;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterInclude;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.transport.amqp.AMQPTransportException;
import org.apache.synapse.transport.amqp.connectionfactory.AMQPTransportConnectionFactory;

public class AMQPTransportConnectionFactoryManager {
    private static Log log = LogFactory.getLog(AMQPTransportConnectionFactoryManager.class);
    private ConcurrentHashMap<String, AMQPTransportConnectionFactory> factories = new ConcurrentHashMap();

    public void addConnectionFactories(ParameterInclude transportInDescription, ExecutorService es) {
        for (Parameter p : transportInDescription.getParameters()) {
            try {
                this.addConnectionFactory(p, es);
            }
            catch (AMQPTransportException e) {
                log.error((Object)("Error whiling adding the connection factory with name '" + p.getName() + "'. "), (Throwable)e);
            }
        }
    }

    public void addConnectionFactory(Parameter parameter, ExecutorService es) throws AMQPTransportException {
        this.factories.put(parameter.getName(), new AMQPTransportConnectionFactory(parameter, es));
    }

    public void addConnectionFactory(String name, AMQPTransportConnectionFactory cf) {
        this.factories.put(name, cf);
    }

    public AMQPTransportConnectionFactory getConnectionFactory(String name) throws AMQPTransportException {
        if (this.factories.containsKey(name)) {
            return this.factories.get(name);
        }
        throw new AMQPTransportException("No connection factory found with the name '" + name + "'");
    }

    public void removeConnectionFactory(String name) throws AMQPTransportException {
        if (this.factories.containsKey(name)) {
            try {
                AMQPTransportConnectionFactory factory = this.factories.remove(name);
                factory.shutDownChannel();
                factory.shutDownConnection();
            }
            catch (IOException e) {
                throw new AMQPTransportException("Could not remove the connection '" + name + "'", e);
            }
        } else {
            throw new AMQPTransportException("No connection factory found with the name '" + name + "'");
        }
    }

    public void shutDownConnectionFactories() throws AMQPTransportException {
        try {
            for (Map.Entry<String, AMQPTransportConnectionFactory> entry : this.factories.entrySet()) {
                AMQPTransportConnectionFactory connectionFactory = entry.getValue();
                connectionFactory.shutDownChannel();
                connectionFactory.shutDownConnection();
            }
        }
        catch (IOException e) {
            throw new AMQPTransportException("Error occurred whiling shutting down connections", e);
        }
    }

    public ConcurrentHashMap<String, AMQPTransportConnectionFactory> getAllFactories() {
        return this.factories;
    }
}

