/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.transport.amqp;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.ParameterInclude;
import org.apache.axis2.transport.base.ProtocolEndpoint;
import org.apache.synapse.transport.amqp.AMQPTransportException;
import org.apache.synapse.transport.amqp.AMQPTransportListener;
import org.apache.synapse.transport.amqp.connectionfactory.AMQPTransportConnectionFactory;
import org.apache.synapse.transport.amqp.pollingtask.AMQPTransportPollingTask;
import org.apache.synapse.transport.amqp.pollingtask.AMQPTransportPollingTaskFactory;

public class AMQPTransportEndpoint
extends ProtocolEndpoint {
    private Set<EndpointReference> endpointReferences = new HashSet<EndpointReference>();
    private ScheduledExecutorService workerPool;
    private AMQPTransportPollingTask pollingTask;
    private AMQPTransportListener transportReceiver;

    public AMQPTransportEndpoint(ScheduledExecutorService workerPool, AMQPTransportListener receiver) {
        this.workerPool = workerPool;
        this.transportReceiver = receiver;
    }

    public AMQPTransportPollingTask getPollingTask() {
        return this.pollingTask;
    }

    public boolean loadConfiguration(ParameterInclude params) throws AxisFault {
        if (!(params instanceof AxisService)) {
            return false;
        }
        try {
            AxisService service = (AxisService)params;
            String conFacName = service.getParameter("transport.amqp.ConnectionFactoryName") != null ? (String)service.getParameter("transport.amqp.ConnectionFactoryName").getValue() : "default";
            AMQPTransportConnectionFactory conFac = this.transportReceiver.getConnectionFactory(conFacName);
            if (conFac == null) {
                throw new AxisFault("No connection factory definition found");
            }
            this.pollingTask = AMQPTransportPollingTaskFactory.createPollingTaskForService(service, this.workerPool, this, conFac, this.transportReceiver.getHaHandler());
        }
        catch (AMQPTransportException e) {
            throw new AxisFault("Could not load the AMQP endpoint configuration, " + e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public EndpointReference[] getEndpointReferences(AxisService service, String ip) throws AxisFault {
        return this.endpointReferences.toArray(new EndpointReference[this.endpointReferences.size()]);
    }
}

