/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy11.builders;

import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.apache.neethi.builders.AssertionBuilder;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.secpolicy.model.AlgorithmSuite;
import org.apache.ws.secpolicy.model.EncryptionToken;
import org.apache.ws.secpolicy.model.Layout;
import org.apache.ws.secpolicy.model.ProtectionToken;
import org.apache.ws.secpolicy.model.SignatureToken;
import org.apache.ws.secpolicy.model.SymmetricBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SymmetricBindingBuilder
implements AssertionBuilder<OMElement> {
    public Assertion build(OMElement element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SymmetricBinding symmetricBinding = new SymmetricBinding(1);
        Policy policy = PolicyEngine.getPolicy((OMElement)element.getFirstElement());
        Iterator iterator = (policy = policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternatives((List)iterator.next(), symmetricBinding);
        }
        return symmetricBinding;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.SYMMETRIC_BINDING};
    }

    private void processAlternatives(List<Assertion> assertions, SymmetricBinding symmetricBinding) {
        try {
            for (Assertion assertion : assertions) {
                QName name = assertion.getName();
                if (SP11Constants.ALGORITHM_SUITE.equals(name)) {
                    symmetricBinding.setAlgorithmSuite((AlgorithmSuite)assertion);
                    continue;
                }
                if (SP11Constants.LAYOUT.equals(name)) {
                    symmetricBinding.setLayout((Layout)assertion);
                    continue;
                }
                if (SP11Constants.INCLUDE_TIMESTAMP.equals(name)) {
                    symmetricBinding.setIncludeTimestamp(true);
                    continue;
                }
                if (SP11Constants.PROTECTION_TOKEN.equals(name)) {
                    symmetricBinding.setProtectionToken((ProtectionToken)assertion);
                    continue;
                }
                if ("EncryptBeforeSigning".equals(name.getLocalPart())) {
                    symmetricBinding.setProtectionOrder("EncryptBeforeSigning");
                    continue;
                }
                if ("SignBeforeEncrypting".equals(name.getLocalPart())) {
                    symmetricBinding.setProtectionOrder("SignBeforeEncrypting");
                    continue;
                }
                if ("OnlySignEntireHeadersAndBody".equals(name.getLocalPart())) {
                    symmetricBinding.setEntireHeadersAndBodySignatures(true);
                    continue;
                }
                if (SP11Constants.ENCRYPT_SIGNATURE.equals(name)) {
                    symmetricBinding.setSignatureProtection(true);
                    continue;
                }
                if (SP11Constants.ENCRYPTION_TOKEN.equals(name)) {
                    symmetricBinding.setEncryptionToken((EncryptionToken)assertion);
                    continue;
                }
                if (!SP11Constants.SIGNATURE_TOKEN.equals(name)) continue;
                symmetricBinding.setSignatureToken((SignatureToken)assertion);
            }
        }
        catch (WSSPolicyException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

