/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxFontInfo;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.export.XlsReportConfiguration;

public class XlsxFontHelper
extends BaseHelper {
    private Map<XlsxFontInfo, Integer> fontCache = new HashMap<XlsxFontInfo, Integer>();
    private String exporterKey;
    private boolean fontSizeFixEnabled;
    private Map<Pair<String, Locale>, String> exportFontCache = new HashMap<Pair<String, Locale>, String>();

    public XlsxFontHelper(JasperReportsContext jasperReportsContext, Writer writer, String exporterKey) {
        super(jasperReportsContext, writer);
        this.exporterKey = exporterKey;
    }

    public void setConfiguration(XlsReportConfiguration configuration) {
        this.fontSizeFixEnabled = configuration.isFontSizeFixEnabled();
    }

    public int getFont(JRExporterGridCell gridCell, Locale locale) {
        if (gridCell == null) {
            return -1;
        }
        return this.getFont(gridCell.getElement(), locale);
    }

    public int getFont(JRLineBox box, Locale locale) {
        return -1;
    }

    public int getFont(JRPrintElement element, Locale locale) {
        JRFont font;
        JRFont jRFont = font = element instanceof JRFont ? (JRFont)((Object)element) : null;
        if (font == null) {
            return -1;
        }
        String fontName = this.exportFont(font, locale);
        XlsxFontInfo xlsxFontInfo = new XlsxFontInfo(element, fontName, this.fontSizeFixEnabled);
        Integer fontIndex = this.fontCache.get(xlsxFontInfo);
        if (fontIndex == null) {
            fontIndex = this.fontCache.size();
            this.export(xlsxFontInfo);
            this.fontCache.put(xlsxFontInfo, fontIndex);
        }
        return fontIndex;
    }

    protected String exportFont(JRFont font, Locale locale) {
        String fontName = font.getFontName();
        Pair<String, Locale> cacheKey = new Pair<String, Locale>(fontName, locale);
        String exportFont = this.exportFontCache.get(cacheKey);
        if (exportFont == null) {
            exportFont = this.fontUtil.getExportFontFamily(fontName, locale, this.exporterKey);
            this.exportFontCache.put(cacheKey, exportFont);
        }
        return exportFont;
    }

    private void export(XlsxFontInfo fontInfo) {
        this.write("<font><sz val=\"" + fontInfo.fontSize + "\"/><color rgb=\"" + fontInfo.color + "\"/><name val=\"" + fontInfo.fontName + "\"/><b val=\"" + fontInfo.isBold + "\"/><i val=\"" + fontInfo.isItalic + "\"/><u val=\"" + (fontInfo.isUnderline ? "single" : "none") + "\"/><strike val=\"" + fontInfo.isStrikeThrough + "\"/><family val=\"2\"/></font>\n");
    }
}

