/*
 * Decompiled with CFR 0.152.
 */
package net.sf.oval.configuration.xml;

import com.thoughtworks.xstream.io.AbstractDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.DomReader;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XIncludeAwareDOMDriver
extends AbstractDriver {
    private static final NameCoder NAME_CODER = new XmlFriendlyNameCoder();

    public XIncludeAwareDOMDriver() {
        super(NAME_CODER);
    }

    public HierarchicalStreamReader createReader(File in) {
        return this.createReader(new InputSource(in.toURI().toASCIIString()));
    }

    private HierarchicalStreamReader createReader(InputSource source) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setCoalescing(true);
            docBuilderFactory.setExpandEntityReferences(true);
            docBuilderFactory.setIgnoringComments(false);
            docBuilderFactory.setNamespaceAware(true);
            docBuilderFactory.setXIncludeAware(true);
            docBuilderFactory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            docBuilderFactory.setValidating(false);
            docBuilderFactory.setSchema(null);
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            docBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setEntityResolver((schemaId, schemaLocation) -> {
                String path = schemaLocation.toLowerCase().replace('\\', '/');
                if (!path.endsWith(".xml") || path.startsWith("file:///c:/windows/") || path.startsWith("file://etc/")) {
                    throw new SAXException("Referencing entity [" + schemaLocation + "] is not allowed!");
                }
                return null;
            });
            Document doc = docBuilder.parse(source);
            return new DomReader(doc, NAME_CODER);
        }
        catch (Exception ex) {
            throw new StreamException((Throwable)ex);
        }
    }

    public HierarchicalStreamReader createReader(InputStream in) {
        return this.createReader(new InputSource(in));
    }

    public HierarchicalStreamReader createReader(Reader in) {
        return this.createReader(new InputSource(in));
    }

    public HierarchicalStreamReader createReader(URL in) {
        return this.createReader(new InputSource(in.toExternalForm()));
    }

    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out));
    }

    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, NAME_CODER);
    }
}

