/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.core.sslreload;

import io.dropwizard.core.Configuration;
import io.dropwizard.core.ConfiguredBundle;
import io.dropwizard.core.setup.Environment;
import io.dropwizard.core.sslreload.SslReloadTask;
import io.dropwizard.jetty.MutableServletContextHandler;
import io.dropwizard.jetty.SslReload;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import org.eclipse.jetty.util.component.LifeCycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslReloadBundle
implements ConfiguredBundle<Configuration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslReloadBundle.class);
    private final SslReloadTask reloadTask = new SslReloadTask();

    @Override
    public void run(Configuration configuration, final Environment environment) {
        environment.getApplicationContext().addEventListener((EventListener)new LifeCycle.Listener(){

            public void lifeCycleStarted(LifeCycle event) {
                HashSet<SslReload> reloaders = new HashSet<SslReload>();
                reloaders.addAll(SslReloadBundle.this.getReloaders(environment.getApplicationContext()));
                reloaders.addAll(SslReloadBundle.this.getReloaders(environment.getAdminContext()));
                LOGGER.info("{} ssl reloaders registered", (Object)reloaders.size());
                SslReloadBundle.this.reloadTask.setReloaders(reloaders);
            }
        });
        environment.admin().addTask(this.reloadTask);
    }

    private Collection<SslReload> getReloaders(MutableServletContextHandler handler) {
        return handler.getServer().getBeans(SslReload.class);
    }
}

