/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.serialization;

import java.util.Map;
import org.apache.storm.serialization.SerializationDelegate;
import org.apache.storm.thrift.TBase;
import org.apache.storm.thrift.TDeserializer;
import org.apache.storm.thrift.TException;
import org.apache.storm.thrift.TSerializer;
import org.apache.storm.utils.Utils;

public class GzipThriftSerializationDelegate
implements SerializationDelegate {
    @Override
    public void prepare(Map<String, Object> topoConf) {
    }

    @Override
    public byte[] serialize(Object object) {
        try {
            return Utils.gzip(new TSerializer().serialize((TBase)object));
        }
        catch (TException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T> T deserialize(byte[] bytes, Class<T> clazz) {
        try {
            TBase instance = (TBase)clazz.newInstance();
            new TDeserializer().deserialize(instance, Utils.gunzip(bytes));
            return (T)instance;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

