/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net.unix;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.util.NativeCodeLoader;

@InterfaceAudience.LimitedPrivate(value={"HDFS"})
public final class DomainSocketWatcher
implements Closeable {
    static Log LOG;
    private static final String loadingFailureReason;
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition processedCond = this.lock.newCondition();
    private final LinkedList<Entry> toAdd = new LinkedList();
    private final TreeMap<Integer, DomainSocket> toRemove = new TreeMap();
    private final int interruptCheckPeriodMs;
    private final DomainSocket[] notificationSockets;
    private boolean closed = false;
    private boolean kicked = false;
    @VisibleForTesting
    final Thread watcherThread = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            if (DomainSocketWatcher.LOG.isDebugEnabled()) {
                DomainSocketWatcher.LOG.debug((Object)(this + ": starting with interruptCheckPeriodMs = " + DomainSocketWatcher.access$300(DomainSocketWatcher.this)));
            }
            entries = new TreeMap<Integer, Entry>();
            fdSet = new FdSet();
            DomainSocketWatcher.access$400(DomainSocketWatcher.this, entries, fdSet);
            while (true) {
                try {
                    DomainSocketWatcher.access$000(DomainSocketWatcher.this).lock();
                    for (int fd : fdSet.getAndClearReadableFds()) {
                        DomainSocketWatcher.access$500(DomainSocketWatcher.this, "getAndClearReadableFds", entries, fdSet, fd);
                    }
                    if (!DomainSocketWatcher.access$600(DomainSocketWatcher.this).isEmpty() || !DomainSocketWatcher.access$700(DomainSocketWatcher.this).isEmpty()) {
                        iter = DomainSocketWatcher.access$600(DomainSocketWatcher.this).iterator();
                        while (iter.hasNext()) {
                            entry = (Entry)iter.next();
                            sock = entry.getDomainSocket();
                            prevEntry = entries.put(sock.fd, entry);
                            Preconditions.checkState((boolean)(prevEntry == null), (Object)(this + ": tried to watch a file descriptor that we " + "were already watching: " + sock));
                            if (DomainSocketWatcher.LOG.isTraceEnabled()) {
                                DomainSocketWatcher.LOG.trace((Object)(this + ": adding fd " + sock.fd));
                            }
                            fdSet.add(sock.fd);
                            iter.remove();
                        }
                        while (true) {
                            if ((entry = DomainSocketWatcher.access$700(DomainSocketWatcher.this).firstEntry()) == null) {
                                DomainSocketWatcher.access$800(DomainSocketWatcher.this).signalAll();
                                break;
                            }
                            DomainSocketWatcher.access$500(DomainSocketWatcher.this, "handlePendingRemovals", entries, fdSet, ((DomainSocket)entry.getValue()).fd);
                        }
                    }
                    if (!DomainSocketWatcher.access$200(DomainSocketWatcher.this)) ** GOTO lbl85
                    if (DomainSocketWatcher.LOG.isDebugEnabled()) {
                        DomainSocketWatcher.LOG.debug((Object)(this.toString() + " thread terminating."));
                    }
                    DomainSocketWatcher.access$000(DomainSocketWatcher.this).unlock();
                    DomainSocketWatcher.access$000(DomainSocketWatcher.this).lock();
                    ** GOTO lbl73
                }
                catch (InterruptedException e) {
                    DomainSocketWatcher.LOG.info((Object)(this.toString() + " terminating on InterruptedException"));
                    DomainSocketWatcher.access$000(DomainSocketWatcher.this).lock();
                    try {
                        DomainSocketWatcher.access$1000(DomainSocketWatcher.this);
                        for (Entry entry : entries.values()) {
                            DomainSocketWatcher.access$1100(DomainSocketWatcher.this, "close", entries, fdSet, entry.getDomainSocket().fd);
                        }
                        entries.clear();
                        fdSet.close();
                        return;
                    }
                    finally {
                        DomainSocketWatcher.access$000(DomainSocketWatcher.this).unlock();
                    }
                }
                catch (Throwable e) {
                    block37: {
                        try {
                            DomainSocketWatcher.LOG.error((Object)(this.toString() + " terminating on exception"), e);
                            DomainSocketWatcher.access$000(DomainSocketWatcher.this).lock();
                        }
                        catch (Throwable var11_21) {
                            DomainSocketWatcher.access$000(DomainSocketWatcher.this).lock();
                            try {
                                DomainSocketWatcher.access$1000(DomainSocketWatcher.this);
                                for (Entry entry : entries.values()) {
                                    DomainSocketWatcher.access$1100(DomainSocketWatcher.this, "close", entries, fdSet, entry.getDomainSocket().fd);
                                }
                                entries.clear();
                                fdSet.close();
                                throw var11_21;
                            }
                            finally {
                                DomainSocketWatcher.access$000(DomainSocketWatcher.this).unlock();
                            }
                        }
lbl73:
                        // 1 sources

                        try {
                            DomainSocketWatcher.access$1000(DomainSocketWatcher.this);
                            for (Entry entry : entries.values()) {
                                DomainSocketWatcher.access$1100(DomainSocketWatcher.this, "close", entries, fdSet, entry.getDomainSocket().fd);
                            }
                            entries.clear();
                            fdSet.close();
                            return;
                        }
                        finally {
                            DomainSocketWatcher.access$000(DomainSocketWatcher.this).unlock();
                        }
lbl85:
                        // 1 sources

                        ** try [egrp 5[TRYBLOCK] [3 : 540->554)] { 
lbl86:
                        // 1 sources

                        if (Thread.interrupted()) {
                            throw new InterruptedException();
                        }
                        break block37;
lbl89:
                        // 1 sources

                        finally {
                            DomainSocketWatcher.access$000(DomainSocketWatcher.this).unlock();
                        }
                    }
                    DomainSocketWatcher.access$900(DomainSocketWatcher.access$300(DomainSocketWatcher.this), fdSet);
                    continue;
                    try {
                        DomainSocketWatcher.access$1000(DomainSocketWatcher.this);
                        for (Entry entry : entries.values()) {
                            DomainSocketWatcher.access$1100(DomainSocketWatcher.this, "close", entries, fdSet, entry.getDomainSocket().fd);
                        }
                        entries.clear();
                        fdSet.close();
                        return;
                    }
                    finally {
                        DomainSocketWatcher.access$000(DomainSocketWatcher.this).unlock();
                    }
                }
                break;
            }
        }
    });
    static final /* synthetic */ boolean $assertionsDisabled;

    private static native void anchorNative();

    public static String getLoadingFailureReason() {
        return loadingFailureReason;
    }

    public DomainSocketWatcher(int interruptCheckPeriodMs) throws IOException {
        if (loadingFailureReason != null) {
            throw new UnsupportedOperationException(loadingFailureReason);
        }
        Preconditions.checkArgument((interruptCheckPeriodMs > 0 ? 1 : 0) != 0);
        this.interruptCheckPeriodMs = interruptCheckPeriodMs;
        this.notificationSockets = DomainSocket.socketpair();
        this.watcherThread.setDaemon(true);
        this.watcherThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable t) {
                LOG.error((Object)(thread + " terminating on unexpected exception"), t);
            }
        });
        this.watcherThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this + ": closing"));
            }
            this.closed = true;
        }
        finally {
            this.lock.unlock();
        }
        this.notificationSockets[0].close();
        Uninterruptibles.joinUninterruptibly((Thread)this.watcherThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public boolean isClosed() {
        this.lock.lock();
        try {
            boolean bl = this.closed;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DomainSocket sock, Handler handler) {
        this.lock.lock();
        try {
            if (this.closed) {
                handler.handle(sock);
                IOUtils.cleanup(LOG, sock);
                return;
            }
            Entry entry = new Entry(sock, handler);
            try {
                sock.refCount.reference();
            }
            catch (ClosedChannelException e1) {
                handler.handle(sock);
                this.lock.unlock();
                return;
            }
            this.toAdd.add(entry);
            this.kick();
            do {
                try {
                    this.processedCond.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } while (this.toAdd.contains(entry));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DomainSocket sock) {
        this.lock.lock();
        try {
            if (this.closed) {
                return;
            }
            this.toRemove.put(sock.fd, sock);
            this.kick();
            do {
                try {
                    this.processedCond.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            } while (this.toRemove.containsKey(sock.fd));
        }
        finally {
            this.lock.unlock();
        }
    }

    private void kick() {
        block4: {
            if (!$assertionsDisabled && !this.lock.isHeldByCurrentThread()) {
                throw new AssertionError();
            }
            if (this.kicked) {
                return;
            }
            try {
                this.notificationSockets[0].getOutputStream().write(0);
                this.kicked = true;
            }
            catch (IOException e) {
                if (this.closed) break block4;
                LOG.error((Object)(this + ": error writing to notificationSockets[0]"), (Throwable)e);
            }
        }
    }

    private boolean sendCallback(String caller, TreeMap<Integer, Entry> entries, FdSet fdSet, int fd) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + ": " + caller + " starting sendCallback for fd " + fd));
        }
        Entry entry = entries.get(fd);
        Preconditions.checkNotNull((Object)entry, (Object)(this + ": fdSet contained " + fd + ", which we were " + "not tracking."));
        DomainSocket sock = entry.getDomainSocket();
        if (entry.getHandler().handle(sock)) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this + ": " + caller + ": closing fd " + fd + " at the request of the handler."));
            }
            if (this.toRemove.remove(fd) != null && LOG.isTraceEnabled()) {
                LOG.trace((Object)(this + ": " + caller + " : sendCallback processed fd " + fd + " in toRemove."));
            }
            try {
                sock.refCount.unreferenceCheckClosed();
            }
            catch (IOException e) {
                Preconditions.checkArgument((boolean)false, (Object)(this + ": file descriptor " + sock.fd + " was closed while " + "still in the poll(2) loop."));
            }
            IOUtils.cleanup(LOG, sock);
            fdSet.remove(fd);
            return true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + ": " + caller + ": sendCallback not " + "closing fd " + fd));
        }
        return false;
    }

    private void sendCallbackAndRemove(String caller, TreeMap<Integer, Entry> entries, FdSet fdSet, int fd) {
        if (this.sendCallback(caller, entries, fdSet, fd)) {
            entries.remove(fd);
        }
    }

    private void addNotificationSocket(TreeMap<Integer, Entry> entries, FdSet fdSet) {
        entries.put(this.notificationSockets[1].fd, new Entry(this.notificationSockets[1], new NotificationHandler()));
        try {
            this.notificationSockets[1].refCount.reference();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        fdSet.add(this.notificationSockets[1].fd);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this + ": adding notificationSocket " + this.notificationSockets[1].fd + ", connected to " + this.notificationSockets[0].fd));
        }
    }

    public String toString() {
        return "DomainSocketWatcher(" + System.identityHashCode(this) + ")";
    }

    private static native int doPoll0(int var0, FdSet var1) throws IOException;

    static /* synthetic */ int access$300(DomainSocketWatcher x0) {
        return x0.interruptCheckPeriodMs;
    }

    static /* synthetic */ void access$400(DomainSocketWatcher x0, TreeMap x1, FdSet x2) {
        x0.addNotificationSocket(x1, x2);
    }

    static /* synthetic */ void access$500(DomainSocketWatcher x0, String x1, TreeMap x2, FdSet x3, int x4) {
        x0.sendCallbackAndRemove(x1, x2, x3, x4);
    }

    static /* synthetic */ LinkedList access$600(DomainSocketWatcher x0) {
        return x0.toAdd;
    }

    static /* synthetic */ TreeMap access$700(DomainSocketWatcher x0) {
        return x0.toRemove;
    }

    static /* synthetic */ Condition access$800(DomainSocketWatcher x0) {
        return x0.processedCond;
    }

    static /* synthetic */ boolean access$200(DomainSocketWatcher x0) {
        return x0.closed;
    }

    static /* synthetic */ int access$900(int x0, FdSet x1) throws IOException {
        return DomainSocketWatcher.doPoll0(x0, x1);
    }

    static /* synthetic */ void access$1000(DomainSocketWatcher x0) {
        x0.kick();
    }

    static /* synthetic */ boolean access$1100(DomainSocketWatcher x0, String x1, TreeMap x2, FdSet x3, int x4) {
        return x0.sendCallback(x1, x2, x3, x4);
    }

    static {
        boolean bl = $assertionsDisabled = !DomainSocketWatcher.class.desiredAssertionStatus();
        if (SystemUtils.IS_OS_WINDOWS) {
            loadingFailureReason = "UNIX Domain sockets are not available on Windows.";
        } else if (!NativeCodeLoader.isNativeCodeLoaded()) {
            loadingFailureReason = "libhadoop cannot be loaded.";
        } else {
            String problem;
            try {
                DomainSocketWatcher.anchorNative();
                problem = null;
            }
            catch (Throwable t) {
                problem = "DomainSocketWatcher#anchorNative got error: " + t.getMessage();
            }
            loadingFailureReason = problem;
        }
        LOG = LogFactory.getLog(DomainSocketWatcher.class);
    }

    private static class FdSet {
        private long data = FdSet.alloc0();

        private static native long alloc0();

        FdSet() {
        }

        native void add(int var1);

        native void remove(int var1);

        native int[] getAndClearReadableFds();

        native void close();
    }

    private static class Entry {
        final DomainSocket socket;
        final Handler handler;

        Entry(DomainSocket socket, Handler handler) {
            this.socket = socket;
            this.handler = handler;
        }

        DomainSocket getDomainSocket() {
            return this.socket;
        }

        Handler getHandler() {
            return this.handler;
        }
    }

    private class NotificationHandler
    implements Handler {
        private NotificationHandler() {
        }

        @Override
        public boolean handle(DomainSocket sock) {
            assert (DomainSocketWatcher.this.lock.isHeldByCurrentThread());
            try {
                DomainSocketWatcher.this.kicked = false;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(this + ": NotificationHandler: doing a read on " + sock.fd));
                }
                if (sock.getInputStream().read() == -1) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)(this + ": NotificationHandler: got EOF on " + sock.fd));
                    }
                    throw new EOFException();
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(this + ": NotificationHandler: read succeeded on " + sock.fd));
                }
                return false;
            }
            catch (IOException e) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(this + ": NotificationHandler: setting closed to " + "true for " + sock.fd));
                }
                DomainSocketWatcher.this.closed = true;
                return true;
            }
        }
    }

    public static interface Handler {
        public boolean handle(DomainSocket var1);
    }
}

