/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.launcher.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.io.artifacts.ArtifactManagerConfig;
import org.apache.sling.feature.launcher.impl.Installation;

public class LauncherConfig
extends ArtifactManagerConfig {
    private static final String HOME = "launcher";
    private static final String CACHE_DIR = "cache";
    private final List<ArtifactId> artifactClashOverrides = new ArrayList<ArtifactId>();
    private final Map<String, String> configClashOverrides = new LinkedHashMap<String, String>();
    private final Map<String, Map<String, String>> extensionConfiguration = new HashMap<String, Map<String, String>>();
    private final LinkedHashSet<String> featureFiles = new LinkedHashSet();
    private final Installation installation = new Installation();
    private volatile File home = new File("launcher");
    private final Map<String, String> variables = new HashMap<String, String>();
    private volatile String frameworkVersion;
    private volatile String frameworkArtifact;
    private volatile ArtifactId launchFeatureId;

    public LauncherConfig() {
        this.setCacheDirectory(new File(this.getHomeDirectory(), CACHE_DIR));
        this.launchFeatureId = ArtifactId.parse((String)"group:assembled:1.0.0");
    }

    public List<ArtifactId> getArtifactClashOverrides() {
        return this.artifactClashOverrides;
    }

    public Map<String, String> getConfigClashOverrides() {
        return this.configClashOverrides;
    }

    public Map<String, Map<String, String>> getExtensionConfiguration() {
        return this.extensionConfiguration;
    }

    public void addFeatureFiles(String ... featureFiles) {
        this.featureFiles.addAll(Arrays.asList(featureFiles));
    }

    public Collection<String> getFeatureFiles() {
        return this.featureFiles;
    }

    public File getHomeDirectory() {
        return this.home;
    }

    public void setHomeDirectory(File file) {
        this.home = file;
    }

    public Installation getInstallation() {
        return this.installation;
    }

    public Map<String, String> getVariables() {
        return this.variables;
    }

    public String getFrameworkVersion() {
        return this.frameworkVersion;
    }

    public void setFrameworkVersion(String frameworkVersion) {
        this.frameworkVersion = frameworkVersion;
    }

    public String getFrameworkArtifact() {
        return this.frameworkArtifact;
    }

    public void setFrameworkArtifact(String frameworkArtifact) {
        this.frameworkArtifact = frameworkArtifact;
    }

    public void setLaunchFeatureId(String id) {
        this.launchFeatureId = ArtifactId.parse((String)id);
    }

    public ArtifactId getLaunchFeatureId() {
        return this.launchFeatureId;
    }
}

