/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentparser;

import org.apache.sling.jcr.contentparser.ContentParser;
import org.apache.sling.jcr.contentparser.ContentType;
import org.apache.sling.jcr.contentparser.ParserOptions;
import org.apache.sling.jcr.contentparser.impl.JcrXmlContentParser;
import org.apache.sling.jcr.contentparser.impl.JsonContentParser;
import org.apache.sling.jcr.contentparser.impl.XmlContentParser;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ContentParserFactory {
    private ContentParserFactory() {
    }

    public static ContentParser create(ContentType type) {
        return ContentParserFactory.create(type, new ParserOptions());
    }

    public static ContentParser create(ContentType type, ParserOptions options) {
        switch (type) {
            case JSON: {
                return new JsonContentParser(options);
            }
            case XML: {
                return new XmlContentParser(options);
            }
            case JCR_XML: {
                return new JcrXmlContentParser(options);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
    }
}

