/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.toolkit.generator.annotation;

import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.toolkit.generator.annotation.ParamAnnotationProcessor;
import org.apache.servicecomb.toolkit.generator.context.ParameterContext;
import org.apache.servicecomb.toolkit.generator.util.SwaggerAnnotationUtils;

public class RequestBodyParamAnnotationProcessor
implements ParamAnnotationProcessor<io.swagger.v3.oas.annotations.parameters.RequestBody, ParameterContext> {
    @Override
    public void process(io.swagger.v3.oas.annotations.parameters.RequestBody requestBodyAnnotation, ParameterContext context) {
        context.setIn(ParameterContext.InType.BODY);
        RequestBody requestBody = new RequestBody();
        requestBody.setRequired(Boolean.valueOf(requestBodyAnnotation.required()));
        requestBody.setDescription(requestBodyAnnotation.description());
        if (StringUtils.isNotEmpty((CharSequence)requestBodyAnnotation.ref())) {
            requestBody.set$ref(requestBodyAnnotation.ref());
        }
        io.swagger.v3.oas.annotations.media.Content[] contentAnnotations = requestBodyAnnotation.content();
        List<Content> contentsFromAnnotation = SwaggerAnnotationUtils.getContentFromAnnotation(contentAnnotations);
        Optional.ofNullable(contentsFromAnnotation).ifPresent(contents -> requestBody.content((Content)contents.get(0)));
        context.setRequestBody(requestBody);
    }
}

