/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os.net;

import com.google.common.annotations.VisibleForTesting;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import org.apache.servicecomb.metrics.core.meter.os.NetMeter;
import org.apache.servicecomb.metrics.core.meter.os.net.NetStat;

public class InterfaceUsage {
    private final String interfaceName;
    private final NetStat receive;
    private final NetStat send;
    private final NetStat packetsReceive;
    private final NetStat packetsSend;

    public InterfaceUsage(MeterRegistry meterRegistry, String name, Tags tags, String interfaceName) {
        this.interfaceName = interfaceName;
        tags = tags.and(new Tag[]{Tag.of((String)"interface", (String)interfaceName)});
        this.receive = new NetStat(0);
        Gauge.builder((String)name, this.receive::getRate).tags((Iterable)tags.and(new Tag[]{NetMeter.TAG_RECEIVE})).register(meterRegistry);
        this.send = new NetStat(8);
        Gauge.builder((String)name, this.send::getRate).tags((Iterable)tags.and(new Tag[]{NetMeter.TAG_SEND})).register(meterRegistry);
        this.packetsReceive = new NetStat(1);
        Gauge.builder((String)name, this.packetsReceive::getRate).tags((Iterable)tags.and(new Tag[]{NetMeter.TAG_PACKETS_RECEIVE})).register(meterRegistry);
        this.packetsSend = new NetStat(9);
        Gauge.builder((String)name, this.packetsSend::getRate).tags((Iterable)tags.and(new Tag[]{NetMeter.TAG_PACKETS_SEND})).register(meterRegistry);
    }

    public void update(String interfaceData, long secondInterval) {
        String[] netInfo = interfaceData.trim().split("\\s+");
        this.receive.update(netInfo, secondInterval);
        this.send.update(netInfo, secondInterval);
        this.packetsReceive.update(netInfo, secondInterval);
        this.packetsSend.update(netInfo, secondInterval);
    }

    @VisibleForTesting
    public NetStat getReceive() {
        return this.receive;
    }

    @VisibleForTesting
    public NetStat getSend() {
        return this.send;
    }

    @VisibleForTesting
    public NetStat getPacketsReceive() {
        return this.packetsReceive;
    }

    @VisibleForTesting
    public NetStat getPacketsSend() {
        return this.packetsSend;
    }

    public String getName() {
        return this.interfaceName;
    }
}

