/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os;

import com.netflix.spectator.api.BasicTag;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Tag;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.servicecomb.metrics.core.meter.os.net.InterfaceUsage;
import org.apache.servicecomb.metrics.core.meter.os.net.NetStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetMeter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NetMeter.class);
    public static final String STATISTIC = "statistic";
    public static final String INTERFACE = "interface";
    public static final Tag TAG_RECEIVE = new BasicTag("statistic", "receive");
    public static final Tag TAG_PACKETS_RECEIVE = new BasicTag("statistic", "receivePackets");
    public static final Tag TAG_SEND = new BasicTag("statistic", "send");
    public static final Tag TAG_PACKETS_SEND = new BasicTag("statistic", "sendPackets");
    private final Id id;
    private final Map<String, InterfaceUsage> interfaceUsageMap = new ConcurrentHashMap<String, InterfaceUsage>();

    public NetMeter(Id id) {
        this.id = id;
        this.refreshNet(1L);
        this.interfaceUsageMap.values().forEach(interfaceUsage -> interfaceUsage.getNetStats().forEach(NetStat::clearRate));
    }

    public void calcMeasurements(List<Measurement> measurements, long msNow, long secondInterval) {
        this.refreshNet(secondInterval);
        this.interfaceUsageMap.values().forEach(interfaceUsage -> interfaceUsage.calcMeasurements(measurements, msNow));
    }

    protected void refreshNet(long secondInterval) {
        try {
            File file = new File("/proc/net/dev");
            List netInfo = FileUtils.readLines((File)file, (Charset)StandardCharsets.UTF_8);
            HashSet<String> nameSet = new HashSet<String>();
            for (int i = 2; i < netInfo.size(); ++i) {
                String interfaceData = (String)netInfo.get(i);
                String[] strings = interfaceData.split(":");
                if (strings.length != 2) {
                    LOGGER.warn(" there is something wrong with {} ", (Object)interfaceData);
                    continue;
                }
                String name = strings[0].trim();
                nameSet.add(name);
                InterfaceUsage interfaceUsage = this.interfaceUsageMap.computeIfAbsent(name, key -> new InterfaceUsage(this.id, (String)key));
                interfaceUsage.update(strings[1], secondInterval);
            }
            for (String interfaceName : this.interfaceUsageMap.keySet()) {
                if (nameSet.contains(interfaceName)) continue;
                this.interfaceUsageMap.remove(interfaceName);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read net info/", (Throwable)e);
        }
    }

    public Map<String, InterfaceUsage> getInterfaceUsageMap() {
        return this.interfaceUsageMap;
    }
}

