/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.protocol.http.server;

import io.reactivex.netty.metrics.MetricsEvent;
import io.reactivex.netty.server.ServerMetricsEvent;

public class HttpServerMetricsEvent<T extends Enum>
extends ServerMetricsEvent<T> {
    public static final HttpServerMetricsEvent<EventType> NEW_REQUEST_RECEIVED = HttpServerMetricsEvent.from(EventType.NewRequestReceived);
    public static final HttpServerMetricsEvent<EventType> REQUEST_HANDLING_START = HttpServerMetricsEvent.from(EventType.RequestHandlingStart);
    public static final HttpServerMetricsEvent<EventType> REQUEST_HEADERS_RECEIVED = HttpServerMetricsEvent.from(EventType.RequestHeadersReceived);
    public static final HttpServerMetricsEvent<EventType> REQUEST_CONTENT_RECEIVED = HttpServerMetricsEvent.from(EventType.RequestContentReceived);
    public static final HttpServerMetricsEvent<EventType> REQUEST_RECEIVE_COMPLETE = HttpServerMetricsEvent.from(EventType.RequestReceiveComplete);
    public static final HttpServerMetricsEvent<EventType> RESPONSE_HEADERS_WRITE_START = HttpServerMetricsEvent.from(EventType.ResponseHeadersWriteStart);
    public static final HttpServerMetricsEvent<EventType> RESPONSE_HEADERS_WRITE_SUCCESS = HttpServerMetricsEvent.from(EventType.ResponseHeadersWriteSuccess);
    public static final HttpServerMetricsEvent<EventType> RESPONSE_HEADERS_WRITE_FAILED = HttpServerMetricsEvent.from(EventType.ResponseHeadersWriteFailed);
    public static final HttpServerMetricsEvent<EventType> RESPONSE_CONTENT_WRITE_START = HttpServerMetricsEvent.from(EventType.ResponseContentWriteStart);
    public static final HttpServerMetricsEvent<EventType> RESPONSE_CONTENT_WRITE_SUCCESS = HttpServerMetricsEvent.from(EventType.ResponseContentWriteSuccess);
    public static final HttpServerMetricsEvent<EventType> RESPONSE_CONTENT_WRITE_FAILED = HttpServerMetricsEvent.from(EventType.ResponseContentWriteFailed);
    public static final HttpServerMetricsEvent<EventType> REQUEST_HANDLING_SUCCESS = HttpServerMetricsEvent.from(EventType.RequestHandlingSuccess);
    public static final HttpServerMetricsEvent<EventType> REQUEST_HANDLING_FAILED = HttpServerMetricsEvent.from(EventType.RequestHandlingFailed);

    protected HttpServerMetricsEvent(T type, boolean isTimed, boolean isError) {
        super(type, isTimed, isError);
    }

    private static HttpServerMetricsEvent<EventType> from(EventType type) {
        return new HttpServerMetricsEvent<EventType>(type, type.isTimed(), type.isError());
    }

    public static enum EventType implements MetricsEvent.MetricEventType
    {
        NewRequestReceived(false, false, Void.class),
        RequestHandlingStart(true, false, Void.class),
        RequestHeadersReceived(false, false, Void.class),
        RequestContentReceived(false, false, Void.class),
        RequestReceiveComplete(true, false, Void.class),
        ResponseHeadersWriteStart(false, false, Void.class),
        ResponseHeadersWriteSuccess(true, false, Void.class),
        ResponseHeadersWriteFailed(true, true, Void.class),
        ResponseContentWriteStart(false, false, Void.class),
        ResponseContentWriteSuccess(true, false, Void.class),
        ResponseContentWriteFailed(true, true, Void.class),
        RequestHandlingSuccess(true, false, Void.class),
        RequestHandlingFailed(true, true, Void.class);

        private final boolean isTimed;
        private final boolean isError;
        private final Class<?> optionalDataType;

        private EventType(boolean isTimed, boolean isError, Class<?> optionalDataType) {
            this.isTimed = isTimed;
            this.isError = isError;
            this.optionalDataType = optionalDataType;
        }

        @Override
        public boolean isTimed() {
            return this.isTimed;
        }

        @Override
        public boolean isError() {
            return this.isError;
        }

        @Override
        public Class<?> getOptionalDataType() {
            return this.optionalDataType;
        }
    }
}

