/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.client;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.servicecomb.config.archaius.sources.ConfigCenterConfigurationSourceImpl;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParseConfigUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseConfigUtils.class);
    private static final ParseConfigUtils INSTANCE = new ParseConfigUtils();
    private LinkedHashMap<String, Map<String, Object>> multiDimensionItems = new LinkedHashMap();
    private final Map<String, Object> flatItems = new HashMap<String, Object>();
    private String currentVersionInfo = "default";
    private ConfigCenterConfigurationSourceImpl.UpdateHandler updateHandler;
    private Lock configLock = new ReentrantLock();

    public ParseConfigUtils(ConfigCenterConfigurationSourceImpl.UpdateHandler updateHandler) {
        this.updateHandler = updateHandler;
    }

    private ParseConfigUtils() {
    }

    public void initWithUpdateHandler(ConfigCenterConfigurationSourceImpl.UpdateHandler updateHandler) {
        if (updateHandler == null) {
            LOGGER.error("when init ParseConfigUtils, updateHandler can not be null");
        }
        this.updateHandler = updateHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshConfigItems(Map<String, Map<String, Object>> remoteItems) {
        try {
            this.configLock.lock();
            String oldRevision = this.currentVersionInfo;
            this.currentVersionInfo = ((Map)remoteItems.getOrDefault("revision", new HashMap())).getOrDefault("version", "default").toString();
            this.currentVersionInfo = this.currentVersionInfo.equals("") ? "default" : this.currentVersionInfo;
            boolean newVersion = remoteItems.remove("revision") != null;
            this.multiDimensionItems.clear();
            this.multiDimensionItems.putAll(remoteItems);
            this.doRefreshItems();
            if (newVersion) {
                LOGGER.info("Updating remote config is done. revision has changed from {} to {}", (Object)oldRevision, (Object)this.currentVersionInfo);
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    public static ParseConfigUtils getInstance() {
        return INSTANCE;
    }

    public String getCurrentVersionInfo() {
        return this.currentVersionInfo;
    }

    public void refreshConfigItemsIncremental(Map<String, Object> action) {
        block7: {
            try {
                this.configLock.lock();
                if ("UPDATE".equals(action.get("action"))) {
                    try {
                        this.multiDimensionItems.put((String)action.get("key"), (Map<String, Object>)JsonUtils.OBJ_MAPPER.readValue(action.get("value").toString(), (TypeReference)new TypeReference<Map<String, Object>>(){}));
                    }
                    catch (IOException e) {
                        LOGGER.error("parse config change action fail");
                    }
                    this.doRefreshItems();
                    break block7;
                }
                if ("DELETE".equals(action.get("action"))) {
                    this.multiDimensionItems.remove(action.get("key"));
                    this.doRefreshItems();
                }
            }
            finally {
                this.configLock.unlock();
            }
        }
    }

    private void doRefreshItems() {
        Map<String, Object> freshFlatItems = this.mergeDimensionItems(this.multiDimensionItems);
        this.notifyItemsChangedNeedRefresh(this.flatItems, freshFlatItems);
        this.flatItems.clear();
        this.flatItems.putAll(freshFlatItems);
    }

    private Map<String, Object> mergeDimensionItems(Map<String, Map<String, Object>> items) {
        HashMap<String, Object> flatMap = new HashMap<String, Object>();
        Set<String> keySet = items.keySet();
        if (keySet.contains("application")) {
            flatMap.putAll(items.get("application"));
            keySet.remove("application");
        }
        if (!keySet.isEmpty()) {
            TreeSet<String> sortedKeys = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.length() - o2.length();
                }
            });
            sortedKeys.addAll(keySet);
            sortedKeys.forEach(key -> flatMap.putAll((Map)items.get(key)));
        }
        return flatMap;
    }

    private void notifyItemsChangedNeedRefresh(Map<String, Object> before, Map<String, Object> after) {
        HashMap<String, Object> itemsCreated = new HashMap<String, Object>();
        HashMap<String, Object> itemsDeleted = new HashMap<String, Object>();
        HashMap<String, Object> itemsModified = new HashMap<String, Object>();
        if (before == null || before.isEmpty()) {
            this.updateHandler.handle("create", after);
            return;
        }
        if (after == null || after.isEmpty()) {
            this.updateHandler.handle("delete", before);
            return;
        }
        for (String itemKey : after.keySet()) {
            if (!before.containsKey(itemKey)) {
                itemsCreated.put(itemKey, after.get(itemKey));
                continue;
            }
            if (after.get(itemKey).equals(before.get(itemKey))) continue;
            itemsModified.put(itemKey, after.get(itemKey));
        }
        for (String itemKey : before.keySet()) {
            if (after.containsKey(itemKey)) continue;
            itemsDeleted.put(itemKey, "");
        }
        this.updateHandler.handle("create", itemsCreated);
        this.updateHandler.handle("set", itemsModified);
        this.updateHandler.handle("delete", itemsDeleted);
    }
}

