/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.samza.coordinator;

import java.util.concurrent.CountDownLatch;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

import static org.mockito.Mockito.verify;


public class TestNoProcessorJobCoordinatorListener {
  @Mock
  private CountDownLatch waitForShutdownLatch;

  private NoProcessorJobCoordinatorListener noProcessorJobCoordinatorListener;

  @Before
  public void setup() {
    MockitoAnnotations.initMocks(this);
    this.noProcessorJobCoordinatorListener = new NoProcessorJobCoordinatorListener(this.waitForShutdownLatch);
  }

  @Test
  public void testOnCoordinatorStop() {
    this.noProcessorJobCoordinatorListener.onCoordinatorStop();

    verify(this.waitForShutdownLatch).countDown();
  }

  @Test
  public void testOnCoordinatorFailure() {
    this.noProcessorJobCoordinatorListener.onCoordinatorFailure(new RuntimeException());

    verify(this.waitForShutdownLatch).countDown();
  }
}