/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.tree.mxml;

import org.apache.royale.compiler.common.XMLName;
import org.apache.royale.compiler.internal.projects.RoyaleProject;
import org.apache.royale.compiler.internal.tree.as.NodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLInstanceNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLNodeBase;
import org.apache.royale.compiler.internal.tree.mxml.MXMLRemoteObjectMethodNode;
import org.apache.royale.compiler.internal.tree.mxml.MXMLTreeBuilder;
import org.apache.royale.compiler.mxml.IMXMLTagData;
import org.apache.royale.compiler.tree.ASTNodeID;
import org.apache.royale.compiler.tree.mxml.IMXMLRemoteObjectNode;

class MXMLRemoteObjectNode
extends MXMLInstanceNode
implements IMXMLRemoteObjectNode {
    private static final String TAG_METHOD = "method";
    private static final String BASENAME_REMOTE_OBJECT_METHOD = "RemoteObjectOperation";

    MXMLRemoteObjectNode(NodeBase parent) {
        super(parent);
    }

    @Override
    public ASTNodeID getNodeID() {
        return ASTNodeID.MXMLRemoteObjectID;
    }

    @Override
    protected void processChildTag(MXMLTreeBuilder builder, IMXMLTagData tag, IMXMLTagData childTag, MXMLNodeBase.MXMLNodeInfo info) {
        if (childTag.getShortName().equals(TAG_METHOD)) {
            RoyaleProject project = builder.getProject();
            XMLName name = new XMLName(childTag.getXMLName().getXMLNamespace(), BASENAME_REMOTE_OBJECT_METHOD);
            String qname = builder.getFileScope().resolveXMLNameToQualifiedName(name, builder.getMXMLDialect());
            String remoteObjectMethodQName = project.getRemoteObjectMethodQName();
            if (qname != null && qname.equals(remoteObjectMethodQName)) {
                MXMLRemoteObjectMethodNode methodNode = new MXMLRemoteObjectMethodNode(this);
                methodNode.setClassReference(project, remoteObjectMethodQName);
                methodNode.initializeFromTag(builder, childTag);
                info.addChildNode(methodNode);
            }
        } else {
            super.processChildTag(builder, tag, childTag, info);
        }
    }
}

