/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.remoting.common;

import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class RemotingConverter {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected static final Object INSTANCE_CREATE_LOCK = new Object();
    protected static volatile RemotingConverter instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RemotingConverter getInstance() {
        if (instance == null) {
            Object object = INSTANCE_CREATE_LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new RemotingConverter();
                }
            }
        }
        return instance;
    }

    public byte[] convertMsgToBytes(MessageExt msg) throws Exception {
        msg.setStoreSize(0);
        if (msg.getTopic().length() > 127) {
            log.warn("Topic length is too long, topic: {}", (Object)msg.getTopic());
        }
        return MessageDecoder.encode((MessageExt)msg, (boolean)false);
    }
}

