/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.benchmark.timer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.srvutil.ServerUtil;

public class TimerConsumer {
    private final String topic;
    private final ScheduledExecutorService scheduledExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ThreadFactoryImpl("ConsumerScheduleThread_"));
    private final StatsBenchmarkConsumer statsBenchmark = new StatsBenchmarkConsumer();
    private final LinkedList<Long[]> snapshotList = new LinkedList();
    private final DefaultMQPushConsumer consumer;

    public TimerConsumer(String[] args) {
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        CommandLine commandLine = ServerUtil.parseCmdLine((String)"benchmarkTimerConsumer", (String[])args, (Options)this.buildCommandlineOptions(options), (CommandLineParser)new DefaultParser());
        if (null == commandLine) {
            System.exit(-1);
        }
        String namesrvAddr = commandLine.hasOption('n') ? commandLine.getOptionValue('t').trim() : "localhost:9876";
        this.topic = commandLine.hasOption('t') ? commandLine.getOptionValue('t').trim() : "BenchmarkTest";
        System.out.printf("namesrvAddr: %s, topic: %s%n", namesrvAddr, this.topic);
        this.consumer = new DefaultMQPushConsumer("benchmark_consumer");
        this.consumer.setInstanceName(Long.toString(System.currentTimeMillis()));
        this.consumer.setNamesrvAddr(namesrvAddr);
    }

    public void startScheduleTask() {
        this.scheduledExecutor.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                TimerConsumer.this.snapshotList.addLast(TimerConsumer.this.statsBenchmark.createSnapshot());
                if (TimerConsumer.this.snapshotList.size() > 10) {
                    TimerConsumer.this.snapshotList.removeFirst();
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        this.scheduledExecutor.scheduleAtFixedRate(new TimerTask(){

            private void printStats() {
                if (TimerConsumer.this.snapshotList.size() >= 10) {
                    Long[] begin = (Long[])TimerConsumer.this.snapshotList.getFirst();
                    Long[] end = (Long[])TimerConsumer.this.snapshotList.getLast();
                    long consumeTps = (long)((double)(end[1] - begin[1]) / (double)(end[0] - begin[0]) * 1000.0);
                    double avgDelayedDuration = (double)(end[2] - begin[2]) / (double)(end[1] - begin[1]);
                    ArrayList<Long> delayedDurationList = new ArrayList<Long>(TimerConsumer.this.statsBenchmark.getDelayedDurationMsSet());
                    if (delayedDurationList.isEmpty()) {
                        System.out.printf("Consume TPS: %d, Avg delayedDuration: %7.3f, Max delayedDuration: 0, %n", consumeTps, avgDelayedDuration);
                    } else {
                        long delayedDuration25 = (Long)delayedDurationList.get((int)((double)delayedDurationList.size() * 0.25));
                        long delayedDuration50 = (Long)delayedDurationList.get((int)((double)delayedDurationList.size() * 0.5));
                        long delayedDuration80 = (Long)delayedDurationList.get((int)((double)delayedDurationList.size() * 0.8));
                        long delayedDuration90 = (Long)delayedDurationList.get((int)((double)delayedDurationList.size() * 0.9));
                        long delayedDuration99 = (Long)delayedDurationList.get((int)((double)delayedDurationList.size() * 0.99));
                        long delayedDuration999 = (Long)delayedDurationList.get((int)((double)delayedDurationList.size() * 0.999));
                        System.out.printf("Consume TPS: %d, Avg delayedDuration: %7.3f, Max delayedDuration: %d, delayDuration %%25: %d, %%50: %d; %%80: %d; %%90: %d; %%99: %d; %%99.9: %d%n", consumeTps, avgDelayedDuration, delayedDurationList.get(delayedDurationList.size() - 1), delayedDuration25, delayedDuration50, delayedDuration80, delayedDuration90, delayedDuration99, delayedDuration999);
                    }
                }
            }

            @Override
            public void run() {
                try {
                    this.printStats();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 10000L, 10000L, TimeUnit.MILLISECONDS);
    }

    public void start() throws MQClientException {
        this.consumer.subscribe(this.topic, "*");
        this.consumer.registerMessageListener(new MessageListenerConcurrently(){

            public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
                MessageExt msg = msgs.get(0);
                long now = System.currentTimeMillis();
                TimerConsumer.this.statsBenchmark.getReceiveMessageTotalCount().incrementAndGet();
                long deliverTimeMs = Long.parseLong(msg.getProperty("MY_RECORD_TIMER_DELIVER_MS"));
                long delayedDuration = now - deliverTimeMs;
                TimerConsumer.this.statsBenchmark.getDelayedDurationMsSet().add(delayedDuration);
                TimerConsumer.this.statsBenchmark.getDelayedDurationMsTotal().addAndGet(delayedDuration);
                return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
            }
        });
        this.consumer.start();
        System.out.printf("Start receiving messages%n", new Object[0]);
    }

    private Options buildCommandlineOptions(Options options) {
        Option opt = new Option("n", "namesrvAddr", true, "Nameserver address, default: localhost:9876");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("t", "topic", true, "Send messages to which topic, default: BenchmarkTest");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    public static void main(String[] args) throws MQClientException {
        TimerConsumer timerConsumer = new TimerConsumer(args);
        timerConsumer.startScheduleTask();
        timerConsumer.start();
    }

    public static class StatsBenchmarkConsumer {
        private final AtomicLong receiveMessageTotalCount = new AtomicLong(0L);
        private final AtomicLong delayedDurationMsTotal = new AtomicLong(0L);
        private final ConcurrentSkipListSet<Long> delayedDurationMsSet = new ConcurrentSkipListSet();

        public Long[] createSnapshot() {
            return new Long[]{System.currentTimeMillis(), this.receiveMessageTotalCount.get(), this.delayedDurationMsTotal.get()};
        }

        public AtomicLong getReceiveMessageTotalCount() {
            return this.receiveMessageTotalCount;
        }

        public AtomicLong getDelayedDurationMsTotal() {
            return this.delayedDurationMsTotal;
        }

        public ConcurrentSkipListSet<Long> getDelayedDurationMsSet() {
            return this.delayedDurationMsSet;
        }
    }
}

