/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.processor;

import io.netty.channel.Channel;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.common.state.StateEventListener;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.MessageReceiptHandle;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.RenewEvent;
import org.apache.rocketmq.proxy.processor.AbstractProcessor;
import org.apache.rocketmq.proxy.processor.MessagingProcessor;
import org.apache.rocketmq.proxy.service.ServiceManager;
import org.apache.rocketmq.proxy.service.receipt.DefaultReceiptHandleManager;

public class ReceiptHandleProcessor
extends AbstractProcessor {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected DefaultReceiptHandleManager receiptHandleManager;

    public ReceiptHandleProcessor(MessagingProcessor messagingProcessor, ServiceManager serviceManager) {
        super(messagingProcessor, serviceManager);
        StateEventListener eventListener = event -> {
            ProxyContext context = this.createContext(event.getEventType().name()).setChannel(event.getKey().getChannel());
            MessageReceiptHandle messageReceiptHandle = event.getMessageReceiptHandle();
            ReceiptHandle handle = ReceiptHandle.decode((String)messageReceiptHandle.getReceiptHandleStr());
            messagingProcessor.changeInvisibleTime(context, handle, messageReceiptHandle.getMessageId(), messageReceiptHandle.getGroup(), messageReceiptHandle.getTopic(), event.getRenewTime()).whenComplete((v, t) -> {
                if (t != null) {
                    event.getFuture().completeExceptionally((Throwable)t);
                    return;
                }
                event.getFuture().complete((AckResult)v);
            });
        };
        this.receiptHandleManager = new DefaultReceiptHandleManager(serviceManager.getMetadataService(), serviceManager.getConsumerManager(), (StateEventListener<RenewEvent>)eventListener);
    }

    protected ProxyContext createContext(String actionName) {
        return ProxyContext.createForInner(((Object)((Object)this)).getClass().getSimpleName() + actionName);
    }

    public void addReceiptHandle(ProxyContext ctx, Channel channel, String group, String msgID, MessageReceiptHandle messageReceiptHandle) {
        this.receiptHandleManager.addReceiptHandle(ctx, channel, group, msgID, messageReceiptHandle);
    }

    public MessageReceiptHandle removeReceiptHandle(ProxyContext ctx, Channel channel, String group, String msgID, String receiptHandle) {
        return this.receiptHandleManager.removeReceiptHandle(ctx, channel, group, msgID, receiptHandle);
    }
}

