/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.internal;

import io.openmessaging.KeyValue;
import io.openmessaging.MessagingAccessPoint;
import io.openmessaging.OMS;
import io.openmessaging.internal.AccessPointURI;
import io.openmessaging.internal.InternalErrorCode;
import java.lang.reflect.Constructor;

public class MessagingAccessPointAdapter {
    public static MessagingAccessPoint getMessagingAccessPoint(String url, KeyValue attributes) {
        AccessPointURI accessPointURI = new AccessPointURI(url);
        String driverImpl = MessagingAccessPointAdapter.parseDriverImpl(accessPointURI.getDriverType(), attributes);
        attributes.put("ACCESS_POINTS", accessPointURI.getHosts());
        attributes.put("DRIVER_IMPL", driverImpl);
        attributes.put("REGION", accessPointURI.getRegion());
        attributes.put("ACCOUNT_ID", accessPointURI.getAccountId());
        try {
            Class<?> driverImplClass = Class.forName(driverImpl);
            Constructor<?> constructor = driverImplClass.getConstructor(KeyValue.class);
            MessagingAccessPoint vendorImpl = (MessagingAccessPoint)constructor.newInstance(attributes);
            MessagingAccessPointAdapter.checkSpecVersion(OMS.specVersion, vendorImpl.implVersion());
            return vendorImpl;
        }
        catch (Throwable e) {
            throw InternalErrorCode.generateInternalException(InternalErrorCode.OMS_DRIVER_UNAVAILABLE, url);
        }
    }

    private static String parseDriverImpl(String driverType, KeyValue attributes) {
        if (attributes.containsKey("DRIVER_IMPL")) {
            return attributes.getString("DRIVER_IMPL");
        }
        return "io.openmessaging." + driverType + ".MessagingAccessPointImpl";
    }

    private static void checkSpecVersion(String specVersion, String implVersion) {
        String majorVerOfImpl;
        String majorVerOfSpec = specVersion.substring(0, specVersion.indexOf(46, specVersion.indexOf(46) + 1));
        try {
            majorVerOfImpl = implVersion.substring(0, implVersion.indexOf(46, implVersion.indexOf(46) + 1));
        }
        catch (Throwable e) {
            throw InternalErrorCode.generateInternalException(InternalErrorCode.IMPL_VERSION_ILLEGAL, implVersion);
        }
        if (!majorVerOfSpec.equals(majorVerOfImpl)) {
            throw InternalErrorCode.generateInternalException(InternalErrorCode.SPEC_IMPL_VERSION_MISMATCH, implVersion, specVersion);
        }
    }
}

