/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.acl.plain;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.acl.PermissionChecker;
import org.apache.rocketmq.acl.common.AclException;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.acl.common.Permission;
import org.apache.rocketmq.acl.plain.PlainAccessData;
import org.apache.rocketmq.acl.plain.PlainAccessResource;
import org.apache.rocketmq.acl.plain.PlainPermissionChecker;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategy;
import org.apache.rocketmq.acl.plain.RemoteAddressStrategyFactory;
import org.apache.rocketmq.common.AclConfig;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.PlainAccessConfig;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.srvutil.AclFileWatchService;

public class PlainPermissionManager {
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqCommon");
    private String fileHome = System.getProperty("rocketmq.home.dir", System.getenv("ROCKETMQ_HOME"));
    private String defaultAclDir;
    private String defaultAclFile;
    private Map<String, Map<String, PlainAccessResource>> aclPlainAccessResourceMap = new HashMap<String, Map<String, PlainAccessResource>>();
    private Map<String, String> accessKeyTable = new HashMap<String, String>();
    private List<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
    private RemoteAddressStrategyFactory remoteAddressStrategyFactory = new RemoteAddressStrategyFactory();
    private Map<String, List<RemoteAddressStrategy>> globalWhiteRemoteAddressStrategyMap = new HashMap<String, List<RemoteAddressStrategy>>();
    private boolean isWatchStart;
    private Map<String, DataVersion> dataVersionMap = new HashMap<String, DataVersion>();
    @Deprecated
    private final DataVersion dataVersion = new DataVersion();
    private List<String> fileList = new ArrayList<String>();
    private final PermissionChecker permissionChecker = new PlainPermissionChecker();

    public PlainPermissionManager() {
        this.defaultAclDir = MixAll.dealFilePath((String)(this.fileHome + File.separator + "conf" + File.separator + "acl"));
        this.defaultAclFile = MixAll.dealFilePath((String)(this.fileHome + File.separator + System.getProperty("rocketmq.acl.plain.file", "conf" + File.separator + "plain_acl.yml")));
        this.load();
        this.watch();
    }

    public List<String> getAllAclFiles(String path) {
        if (!new File(path).exists()) {
            log.info("The default acl dir {} is not exist", (Object)path);
            return new ArrayList<String>();
        }
        ArrayList<String> allAclFileFullPath = new ArrayList<String>();
        File file = new File(path);
        File[] files = file.listFiles();
        for (int i = 0; files != null && i < files.length; ++i) {
            String fileName = files[i].getAbsolutePath();
            File f = new File(fileName);
            if (fileName.equals(this.fileHome + "/conf/tools.yml")) continue;
            if (fileName.endsWith(".yml") || fileName.endsWith(".yaml")) {
                allAclFileFullPath.add(fileName);
                continue;
            }
            if (!f.isDirectory()) continue;
            allAclFileFullPath.addAll(this.getAllAclFiles(fileName));
        }
        return allAclFileFullPath;
    }

    public void load() {
        if (this.fileHome == null || this.fileHome.isEmpty()) {
            return;
        }
        HashMap<String, Map<String, PlainAccessResource>> aclPlainAccessResourceMap = new HashMap<String, Map<String, PlainAccessResource>>();
        HashMap<String, String> accessKeyTable = new HashMap<String, String>();
        ArrayList<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
        HashMap<String, List<RemoteAddressStrategy>> globalWhiteRemoteAddressStrategyMap = new HashMap<String, List<RemoteAddressStrategy>>();
        HashMap<String, DataVersion> dataVersionMap = new HashMap<String, DataVersion>();
        this.assureAclConfigFilesExist();
        this.fileList = this.getAllAclFiles(this.defaultAclDir);
        if (new File(this.defaultAclFile).exists() && !this.fileList.contains(this.defaultAclFile)) {
            this.fileList.add(this.defaultAclFile);
        }
        for (String path : this.fileList) {
            String currentFile = MixAll.dealFilePath((String)path);
            PlainAccessData plainAclConfData = AclUtils.getYamlDataObject(currentFile, PlainAccessData.class);
            if (plainAclConfData == null) {
                log.warn("No data in file {}", (Object)currentFile);
                continue;
            }
            log.info("Broker plain acl conf data is : {}", (Object)plainAclConfData.toString());
            ArrayList<RemoteAddressStrategy> globalWhiteRemoteAddressStrategyList = new ArrayList<RemoteAddressStrategy>();
            List<String> globalWhiteRemoteAddressesList = plainAclConfData.getGlobalWhiteRemoteAddresses();
            if (globalWhiteRemoteAddressesList != null && !globalWhiteRemoteAddressesList.isEmpty()) {
                for (String address : globalWhiteRemoteAddressesList) {
                    globalWhiteRemoteAddressStrategyList.add(this.remoteAddressStrategyFactory.getRemoteAddressStrategy(address));
                }
            }
            if (!globalWhiteRemoteAddressStrategyList.isEmpty()) {
                globalWhiteRemoteAddressStrategyMap.put(currentFile, globalWhiteRemoteAddressStrategyList);
                globalWhiteRemoteAddressStrategy.addAll(globalWhiteRemoteAddressStrategyList);
            }
            List<PlainAccessConfig> accounts = plainAclConfData.getAccounts();
            HashMap<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>();
            if (accounts != null && !accounts.isEmpty()) {
                for (PlainAccessConfig plainAccessConfig : accounts) {
                    PlainAccessResource plainAccessResource = this.buildPlainAccessResource(plainAccessConfig);
                    if (accessKeyTable.get(plainAccessResource.getAccessKey()) == null) {
                        plainAccessResourceMap.put(plainAccessResource.getAccessKey(), plainAccessResource);
                        accessKeyTable.put(plainAccessResource.getAccessKey(), currentFile);
                        continue;
                    }
                    log.warn("The accessKey {} is repeated in multiple ACL files", (Object)plainAccessResource.getAccessKey());
                }
            }
            if (!plainAccessResourceMap.isEmpty()) {
                aclPlainAccessResourceMap.put(currentFile, plainAccessResourceMap);
            }
            List<PlainAccessData.DataVersion> dataVersions = plainAclConfData.getDataVersion();
            DataVersion dataVersion = new DataVersion();
            if (dataVersions != null && !dataVersions.isEmpty()) {
                DataVersion firstElement = new DataVersion();
                firstElement.setCounter(new AtomicLong(dataVersions.get(0).getCounter()));
                firstElement.setTimestamp(dataVersions.get(0).getTimestamp());
                dataVersion.assignNewOne(firstElement);
            }
            dataVersionMap.put(currentFile, dataVersion);
        }
        if (dataVersionMap.containsKey(this.defaultAclFile)) {
            this.dataVersion.assignNewOne((DataVersion)dataVersionMap.get(this.defaultAclFile));
        }
        this.dataVersionMap = dataVersionMap;
        this.globalWhiteRemoteAddressStrategyMap = globalWhiteRemoteAddressStrategyMap;
        this.globalWhiteRemoteAddressStrategy = globalWhiteRemoteAddressStrategy;
        this.aclPlainAccessResourceMap = aclPlainAccessResourceMap;
        this.accessKeyTable = accessKeyTable;
    }

    private void assureAclConfigFilesExist() {
        Path defaultAclFilePath = Paths.get(this.defaultAclFile, new String[0]);
        if (!Files.exists(defaultAclFilePath, new LinkOption[0])) {
            try {
                Files.createFile(defaultAclFilePath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
            }
            catch (IOException e) {
                log.error("Error in creating " + this.defaultAclFile, (Throwable)e);
                throw new AclException(e.getMessage());
            }
        }
    }

    public void load(String aclFilePath) {
        List<PlainAccessConfig> accounts;
        aclFilePath = MixAll.dealFilePath((String)aclFilePath);
        HashMap<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>();
        ArrayList<RemoteAddressStrategy> globalWhiteRemoteAddressStrategy = new ArrayList<RemoteAddressStrategy>();
        PlainAccessData plainAclConfData = AclUtils.getYamlDataObject(aclFilePath, PlainAccessData.class);
        if (plainAclConfData == null) {
            log.warn("No data in {}, skip it", (Object)aclFilePath);
            return;
        }
        log.info("Broker plain acl conf data is : {}", (Object)plainAclConfData.toString());
        List<String> globalWhiteRemoteAddressesList = plainAclConfData.getGlobalWhiteRemoteAddresses();
        if (globalWhiteRemoteAddressesList != null && !globalWhiteRemoteAddressesList.isEmpty()) {
            for (String string : globalWhiteRemoteAddressesList) {
                globalWhiteRemoteAddressStrategy.add(this.remoteAddressStrategyFactory.getRemoteAddressStrategy(string));
            }
        }
        this.globalWhiteRemoteAddressStrategy.addAll(globalWhiteRemoteAddressStrategy);
        if (this.globalWhiteRemoteAddressStrategyMap.get(aclFilePath) != null) {
            List<RemoteAddressStrategy> remoteAddressStrategyList = this.globalWhiteRemoteAddressStrategyMap.get(aclFilePath);
            for (RemoteAddressStrategy remoteAddressStrategy : remoteAddressStrategyList) {
                this.globalWhiteRemoteAddressStrategy.remove(remoteAddressStrategy);
            }
            this.globalWhiteRemoteAddressStrategyMap.put(aclFilePath, globalWhiteRemoteAddressStrategy);
        }
        if ((accounts = plainAclConfData.getAccounts()) != null && !accounts.isEmpty()) {
            for (PlainAccessConfig plainAccessConfig : accounts) {
                PlainAccessResource plainAccessResource = this.buildPlainAccessResource(plainAccessConfig);
                String oldPath = this.accessKeyTable.get(plainAccessResource.getAccessKey());
                if (oldPath == null || aclFilePath.equals(oldPath)) {
                    plainAccessResourceMap.put(plainAccessResource.getAccessKey(), plainAccessResource);
                    this.accessKeyTable.put(plainAccessResource.getAccessKey(), aclFilePath);
                    continue;
                }
                log.warn("The accessKey {} is repeated in multiple ACL files", (Object)plainAccessResource.getAccessKey());
            }
        }
        List<PlainAccessData.DataVersion> list = plainAclConfData.getDataVersion();
        DataVersion dataVersion = new DataVersion();
        if (list != null && !list.isEmpty()) {
            DataVersion firstElement = new DataVersion();
            firstElement.setCounter(new AtomicLong(list.get(0).getCounter()));
            firstElement.setTimestamp(list.get(0).getTimestamp());
            dataVersion.assignNewOne(firstElement);
        }
        this.aclPlainAccessResourceMap.put(aclFilePath, plainAccessResourceMap);
        this.dataVersionMap.put(aclFilePath, dataVersion);
        if (aclFilePath.equals(this.defaultAclFile)) {
            this.dataVersion.assignNewOne(dataVersion);
        }
    }

    @Deprecated
    public String getAclConfigDataVersion() {
        return this.dataVersion.toJson();
    }

    public Map<String, DataVersion> getDataVersionMap() {
        return this.dataVersionMap;
    }

    public PlainAccessData updateAclConfigFileVersion(String aclFileName, PlainAccessData updateAclConfigMap) {
        List<PlainAccessData.DataVersion> dataVersions = updateAclConfigMap.getDataVersion();
        DataVersion dataVersion = new DataVersion();
        if (dataVersions != null && !dataVersions.isEmpty()) {
            dataVersion.setTimestamp(dataVersions.get(0).getTimestamp());
            dataVersion.setCounter(new AtomicLong(dataVersions.get(0).getCounter()));
        }
        dataVersion.nextVersion();
        ArrayList<PlainAccessData.DataVersion> versionElement = new ArrayList<PlainAccessData.DataVersion>();
        PlainAccessData.DataVersion dataVersionNew = new PlainAccessData.DataVersion();
        dataVersionNew.setTimestamp(dataVersion.getTimestamp());
        dataVersionNew.setCounter(dataVersion.getCounter().get());
        versionElement.add(dataVersionNew);
        updateAclConfigMap.setDataVersion(versionElement);
        this.dataVersionMap.put(aclFileName, dataVersion);
        return updateAclConfigMap;
    }

    public boolean updateAccessConfig(PlainAccessConfig plainAccessConfig) {
        List<PlainAccessConfig> accounts;
        PlainAccessData aclAccessConfigMap;
        if (plainAccessConfig == null) {
            log.error("Parameter value plainAccessConfig is null,Please check your parameter");
            throw new AclException("Parameter value plainAccessConfig is null, Please check your parameter");
        }
        this.checkPlainAccessConfig(plainAccessConfig);
        Permission.checkResourcePerms(plainAccessConfig.getTopicPerms());
        Permission.checkResourcePerms(plainAccessConfig.getGroupPerms());
        if (this.accessKeyTable.containsKey(plainAccessConfig.getAccessKey())) {
            PlainAccessConfig updateAccountMap = null;
            String aclFileName = this.accessKeyTable.get(plainAccessConfig.getAccessKey());
            PlainAccessData aclAccessConfigMap2 = AclUtils.getYamlDataObject(aclFileName, PlainAccessData.class);
            List<PlainAccessConfig> accounts2 = aclAccessConfigMap2.getAccounts();
            if (null != accounts2) {
                for (PlainAccessConfig account : accounts2) {
                    if (!account.getAccessKey().equals(plainAccessConfig.getAccessKey())) continue;
                    accounts2.remove(account);
                    updateAccountMap = this.createAclAccessConfigMap(account, plainAccessConfig);
                    accounts2.add(updateAccountMap);
                    aclAccessConfigMap2.setAccounts(accounts2);
                    break;
                }
            } else {
                accounts2 = new LinkedList<PlainAccessConfig>();
                updateAccountMap = this.createAclAccessConfigMap(null, plainAccessConfig);
                accounts2.add(updateAccountMap);
                aclAccessConfigMap2.setAccounts(accounts2);
            }
            Map<String, PlainAccessResource> accountMap = this.aclPlainAccessResourceMap.get(aclFileName);
            if (accountMap == null) {
                accountMap = new HashMap<String, PlainAccessResource>(1);
                accountMap.put(plainAccessConfig.getAccessKey(), this.buildPlainAccessResource(plainAccessConfig));
            } else if (accountMap.isEmpty()) {
                accountMap.put(plainAccessConfig.getAccessKey(), this.buildPlainAccessResource(plainAccessConfig));
            } else {
                for (Map.Entry<String, PlainAccessResource> entry : accountMap.entrySet()) {
                    if (!entry.getValue().getAccessKey().equals(plainAccessConfig.getAccessKey())) continue;
                    PlainAccessResource plainAccessResource = this.buildPlainAccessResource(plainAccessConfig);
                    accountMap.put(entry.getKey(), plainAccessResource);
                    break;
                }
            }
            this.aclPlainAccessResourceMap.put(aclFileName, accountMap);
            return AclUtils.writeDataObject(aclFileName, this.updateAclConfigFileVersion(aclFileName, aclAccessConfigMap2));
        }
        String fileName = MixAll.dealFilePath((String)this.defaultAclFile);
        if (this.aclPlainAccessResourceMap.get(this.defaultAclFile) == null || this.aclPlainAccessResourceMap.get(this.defaultAclFile).size() == 0) {
            try {
                File defaultAclFile = new File(fileName);
                if (!defaultAclFile.exists()) {
                    defaultAclFile.createNewFile();
                }
            }
            catch (IOException e) {
                log.warn("create default acl file has exception when update accessConfig. ", (Throwable)e);
            }
        }
        if ((aclAccessConfigMap = AclUtils.getYamlDataObject(this.defaultAclFile, PlainAccessData.class)) == null) {
            aclAccessConfigMap = new PlainAccessData();
        }
        if (null == (accounts = aclAccessConfigMap.getAccounts())) {
            accounts = new ArrayList<PlainAccessConfig>();
        }
        accounts.add(this.createAclAccessConfigMap(null, plainAccessConfig));
        aclAccessConfigMap.setAccounts(accounts);
        this.accessKeyTable.put(plainAccessConfig.getAccessKey(), fileName);
        if (this.aclPlainAccessResourceMap.get(fileName) == null) {
            HashMap<String, PlainAccessResource> plainAccessResourceMap = new HashMap<String, PlainAccessResource>(1);
            plainAccessResourceMap.put(plainAccessConfig.getAccessKey(), this.buildPlainAccessResource(plainAccessConfig));
            this.aclPlainAccessResourceMap.put(fileName, plainAccessResourceMap);
        } else {
            Map<String, PlainAccessResource> plainAccessResourceMap = this.aclPlainAccessResourceMap.get(fileName);
            plainAccessResourceMap.put(plainAccessConfig.getAccessKey(), this.buildPlainAccessResource(plainAccessConfig));
            this.aclPlainAccessResourceMap.put(fileName, plainAccessResourceMap);
        }
        return AclUtils.writeDataObject(this.defaultAclFile, this.updateAclConfigFileVersion(this.defaultAclFile, aclAccessConfigMap));
    }

    public PlainAccessConfig createAclAccessConfigMap(PlainAccessConfig existedAccountMap, PlainAccessConfig plainAccessConfig) {
        PlainAccessConfig newAccountsMap = null;
        newAccountsMap = existedAccountMap == null ? new PlainAccessConfig() : existedAccountMap;
        if (StringUtils.isEmpty((CharSequence)plainAccessConfig.getAccessKey()) || plainAccessConfig.getAccessKey().length() <= 6) {
            throw new AclException(String.format("The accessKey=%s cannot be null and length should longer than 6", plainAccessConfig.getAccessKey()));
        }
        newAccountsMap.setAccessKey(plainAccessConfig.getAccessKey());
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getSecretKey())) {
            if (plainAccessConfig.getSecretKey().length() <= 6) {
                throw new AclException(String.format("The secretKey=%s value length should longer than 6", plainAccessConfig.getSecretKey()));
            }
            newAccountsMap.setSecretKey(plainAccessConfig.getSecretKey());
        }
        if (plainAccessConfig.getWhiteRemoteAddress() != null) {
            newAccountsMap.setWhiteRemoteAddress(plainAccessConfig.getWhiteRemoteAddress());
        }
        if (!StringUtils.isEmpty((CharSequence)String.valueOf(plainAccessConfig.isAdmin()))) {
            newAccountsMap.setAdmin(plainAccessConfig.isAdmin());
        }
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getDefaultTopicPerm())) {
            newAccountsMap.setDefaultTopicPerm(plainAccessConfig.getDefaultTopicPerm());
        }
        if (!StringUtils.isEmpty((CharSequence)plainAccessConfig.getDefaultGroupPerm())) {
            newAccountsMap.setDefaultGroupPerm(plainAccessConfig.getDefaultGroupPerm());
        }
        if (plainAccessConfig.getTopicPerms() != null) {
            newAccountsMap.setTopicPerms(plainAccessConfig.getTopicPerms());
        }
        if (plainAccessConfig.getGroupPerms() != null) {
            newAccountsMap.setGroupPerms(plainAccessConfig.getGroupPerms());
        }
        return newAccountsMap;
    }

    public boolean deleteAccessConfig(String accessKey) {
        if (StringUtils.isEmpty((CharSequence)accessKey)) {
            log.error("Parameter value accessKey is null or empty String,Please check your parameter");
            return false;
        }
        if (this.accessKeyTable.containsKey(accessKey)) {
            String aclFileName = this.accessKeyTable.get(accessKey);
            PlainAccessData aclAccessConfigData = AclUtils.getYamlDataObject(aclFileName, PlainAccessData.class);
            if (aclAccessConfigData == null) {
                log.warn("No data found in {} when deleting access config of {}", (Object)aclFileName, (Object)accessKey);
                return true;
            }
            List<PlainAccessConfig> accounts = aclAccessConfigData.getAccounts();
            Iterator<PlainAccessConfig> itemIterator = accounts.iterator();
            while (itemIterator.hasNext()) {
                if (!itemIterator.next().getAccessKey().equals(accessKey)) continue;
                itemIterator.remove();
                this.accessKeyTable.remove(accessKey);
                aclAccessConfigData.setAccounts(accounts);
                return AclUtils.writeDataObject(aclFileName, this.updateAclConfigFileVersion(aclFileName, aclAccessConfigData));
            }
        }
        return false;
    }

    public boolean updateGlobalWhiteAddrsConfig(List<String> globalWhiteAddrsList) {
        return this.updateGlobalWhiteAddrsConfig(globalWhiteAddrsList, this.defaultAclFile);
    }

    public boolean updateGlobalWhiteAddrsConfig(List<String> globalWhiteAddrsList, String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            fileName = this.defaultAclFile;
        }
        if (globalWhiteAddrsList == null) {
            log.error("Parameter value globalWhiteAddrsList is null,Please check your parameter");
            return false;
        }
        File file = new File(fileName);
        if (!file.exists() || file.isDirectory()) {
            log.error("Parameter value " + fileName + " is not exist or is a directory, please check your parameter");
            return false;
        }
        if (!file.getAbsolutePath().startsWith(this.fileHome)) {
            log.error("Parameter value " + fileName + " is not in the directory rocketmq.home.dir " + this.fileHome);
            return false;
        }
        if (!fileName.endsWith(".yml") && fileName.endsWith(".yaml")) {
            log.error("Parameter value " + fileName + " is not a ACL configuration file");
            return false;
        }
        PlainAccessData aclAccessConfigMap = AclUtils.getYamlDataObject(fileName, PlainAccessData.class);
        if (aclAccessConfigMap == null) {
            aclAccessConfigMap = new PlainAccessData();
            log.info("No data in {}, create a new aclAccessConfigMap", (Object)fileName);
        }
        aclAccessConfigMap.setGlobalWhiteRemoteAddresses(new ArrayList<String>(globalWhiteAddrsList));
        return AclUtils.writeDataObject(fileName, this.updateAclConfigFileVersion(fileName, aclAccessConfigMap));
    }

    public AclConfig getAllAclConfig() {
        AclConfig aclConfig = new AclConfig();
        ArrayList<PlainAccessConfig> configs = new ArrayList<PlainAccessConfig>();
        ArrayList<String> whiteAddrs = new ArrayList<String>();
        HashSet<String> accessKeySets = new HashSet<String>();
        for (String path : this.fileList) {
            List<PlainAccessConfig> plainAccessConfigs;
            PlainAccessData plainAclConfData = AclUtils.getYamlDataObject(path, PlainAccessData.class);
            if (plainAclConfData == null) continue;
            List<String> globalWhiteAddrs = plainAclConfData.getGlobalWhiteRemoteAddresses();
            if (globalWhiteAddrs != null && !globalWhiteAddrs.isEmpty()) {
                whiteAddrs.addAll(globalWhiteAddrs);
            }
            if ((plainAccessConfigs = plainAclConfData.getAccounts()) == null || plainAccessConfigs.isEmpty()) continue;
            for (PlainAccessConfig accessConfig : plainAccessConfigs) {
                if (accessKeySets.contains(accessConfig.getAccessKey())) continue;
                accessKeySets.add(accessConfig.getAccessKey());
                PlainAccessConfig plainAccessConfig = new PlainAccessConfig();
                plainAccessConfig.setGroupPerms(accessConfig.getGroupPerms());
                plainAccessConfig.setDefaultTopicPerm(accessConfig.getDefaultTopicPerm());
                plainAccessConfig.setDefaultGroupPerm(accessConfig.getDefaultGroupPerm());
                plainAccessConfig.setAccessKey(accessConfig.getAccessKey());
                plainAccessConfig.setSecretKey(accessConfig.getSecretKey());
                plainAccessConfig.setAdmin(accessConfig.isAdmin());
                plainAccessConfig.setTopicPerms(accessConfig.getTopicPerms());
                plainAccessConfig.setWhiteRemoteAddress(accessConfig.getWhiteRemoteAddress());
                configs.add(plainAccessConfig);
            }
        }
        aclConfig.setPlainAccessConfigs(configs);
        aclConfig.setGlobalWhiteAddrs(whiteAddrs);
        return aclConfig;
    }

    private void watch() {
        try {
            AclFileWatchService aclFileWatchService = new AclFileWatchService(this.defaultAclDir, this.defaultAclFile, new AclFileWatchService.Listener(){

                public void onFileChanged(String aclFileName) {
                    PlainPermissionManager.this.load(aclFileName);
                }

                public void onFileNumChanged(String path) {
                    PlainPermissionManager.this.load();
                }
            });
            aclFileWatchService.start();
            log.info("Succeed to start AclFileWatchService");
            this.isWatchStart = true;
        }
        catch (Exception e) {
            log.error("Failed to start AclWatcherService", (Throwable)e);
        }
    }

    void checkPerm(PlainAccessResource needCheckedAccess, PlainAccessResource ownedAccess) {
        this.permissionChecker.check(needCheckedAccess, ownedAccess);
    }

    void clearPermissionInfo() {
        this.aclPlainAccessResourceMap.clear();
        this.accessKeyTable.clear();
        this.globalWhiteRemoteAddressStrategy.clear();
    }

    public void checkPlainAccessConfig(PlainAccessConfig plainAccessConfig) throws AclException {
        if (plainAccessConfig.getAccessKey() == null || plainAccessConfig.getSecretKey() == null || plainAccessConfig.getAccessKey().length() <= 6 || plainAccessConfig.getSecretKey().length() <= 6) {
            throw new AclException(String.format("The accessKey=%s and secretKey=%s cannot be null and length should longer than 6", plainAccessConfig.getAccessKey(), plainAccessConfig.getSecretKey()));
        }
    }

    public PlainAccessResource buildPlainAccessResource(PlainAccessConfig plainAccessConfig) throws AclException {
        this.checkPlainAccessConfig(plainAccessConfig);
        return PlainAccessResource.build(plainAccessConfig, this.remoteAddressStrategyFactory.getRemoteAddressStrategy(plainAccessConfig.getWhiteRemoteAddress()));
    }

    public void validate(PlainAccessResource plainAccessResource) {
        Byte permission;
        for (RemoteAddressStrategy remoteAddressStrategy : this.globalWhiteRemoteAddressStrategy) {
            if (!remoteAddressStrategy.match(plainAccessResource)) continue;
            return;
        }
        if (plainAccessResource.getAccessKey() == null) {
            throw new AclException("No accessKey is configured");
        }
        if (!this.accessKeyTable.containsKey(plainAccessResource.getAccessKey())) {
            throw new AclException(String.format("No acl config for %s", plainAccessResource.getAccessKey()));
        }
        String aclFileName = this.accessKeyTable.get(plainAccessResource.getAccessKey());
        PlainAccessResource ownedAccess = (PlainAccessResource)((Map)this.aclPlainAccessResourceMap.getOrDefault(aclFileName, new HashMap())).get(plainAccessResource.getAccessKey());
        if (ownedAccess == null) {
            throw new AclException(String.format("No PlainAccessResource for accessKey=%s", plainAccessResource.getAccessKey()));
        }
        if (ownedAccess.getRemoteAddressStrategy().match(plainAccessResource)) {
            return;
        }
        String signature = AclUtils.calSignature(plainAccessResource.getContent(), ownedAccess.getSecretKey());
        if (!signature.equals(plainAccessResource.getSignature())) {
            throw new AclException(String.format("Check signature failed for accessKey=%s", plainAccessResource.getAccessKey()));
        }
        Map<String, Byte> resourcePermMap = plainAccessResource.getResourcePermMap();
        if (resourcePermMap != null && (permission = resourcePermMap.get("RMQ_SYS_TRACE_TOPIC")) != null && permission == 4) {
            return;
        }
        this.checkPerm(plainAccessResource, ownedAccess);
    }

    public boolean isWatchStart() {
        return this.isWatchStart;
    }
}

