/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tieredstore.util;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.topic.TopicValidator;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.tieredstore.common.TieredMessageStoreConfig;
import org.apache.rocketmq.tieredstore.metadata.TieredMetadataStore;

public class TieredStoreUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"RocketmqTieredStore");
    public static final long BYTE = 1L;
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final long PB = 0x4000000000000L;
    public static final long EB = 0x1000000000000000L;
    public static final String TIERED_STORE_LOGGER_NAME = "RocketmqTieredStore";
    public static final String RMQ_SYS_TIERED_STORE_INDEX_TOPIC = "rmq_sys_INDEX";
    public static final int MSG_ID_LENGTH = 16;
    private static final DecimalFormat DEC_FORMAT = new DecimalFormat("#.##");
    private static final List<String> SYSTEM_TOPIC_LIST = new LinkedList<String>(){
        {
            this.add(TieredStoreUtil.RMQ_SYS_TIERED_STORE_INDEX_TOPIC);
        }
    };
    private static final List<String> SYSTEM_TOPIC_WHITE_LIST = new LinkedList<String>();
    @VisibleForTesting
    public static volatile TieredMetadataStore metadataStoreInstance;

    private static String formatSize(long size, long divider, String unitName) {
        return DEC_FORMAT.format((double)size / (double)divider) + unitName;
    }

    public static String toHumanReadable(long size) {
        if (size < 0L) {
            return String.valueOf(size);
        }
        if (size >= 0x1000000000000000L) {
            return TieredStoreUtil.formatSize(size, 0x1000000000000000L, "EB");
        }
        if (size >= 0x4000000000000L) {
            return TieredStoreUtil.formatSize(size, 0x4000000000000L, "PB");
        }
        if (size >= 0x10000000000L) {
            return TieredStoreUtil.formatSize(size, 0x10000000000L, "TB");
        }
        if (size >= 0x40000000L) {
            return TieredStoreUtil.formatSize(size, 0x40000000L, "GB");
        }
        if (size >= 0x100000L) {
            return TieredStoreUtil.formatSize(size, 0x100000L, "MB");
        }
        if (size >= 1024L) {
            return TieredStoreUtil.formatSize(size, 1024L, "KB");
        }
        return TieredStoreUtil.formatSize(size, 1L, "Bytes");
    }

    public static String getHash(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            return String.format("%032x", new BigInteger(1, digest)).substring(0, 8);
        }
        catch (Exception ignore) {
            return "";
        }
    }

    public static String offset2FileName(long offset) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMinimumIntegerDigits(20);
        numberFormat.setMaximumFractionDigits(0);
        numberFormat.setGroupingUsed(false);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(Long.toString(offset).getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            String hash = String.format("%032x", new BigInteger(1, digest)).substring(0, 8);
            return hash + numberFormat.format(offset);
        }
        catch (Exception ignore) {
            return numberFormat.format(offset);
        }
    }

    public static long fileName2Offset(String fileName) {
        return Long.parseLong(fileName.substring(fileName.length() - 20));
    }

    public static void addSystemTopic(String topic) {
        SYSTEM_TOPIC_LIST.add(topic);
    }

    public static boolean isSystemTopic(String topic) {
        if (StringUtils.isBlank((CharSequence)topic)) {
            return false;
        }
        if (SYSTEM_TOPIC_WHITE_LIST.contains(topic)) {
            return false;
        }
        if (SYSTEM_TOPIC_LIST.contains(topic)) {
            return true;
        }
        return TopicValidator.isSystemTopic((String)topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TieredMetadataStore getMetadataStore(TieredMessageStoreConfig storeConfig) {
        if (storeConfig == null) {
            return metadataStoreInstance;
        }
        if (metadataStoreInstance != null) return metadataStoreInstance;
        Class<TieredMetadataStore> clazz = TieredMetadataStore.class;
        synchronized (TieredMetadataStore.class) {
            if (metadataStoreInstance != null) return metadataStoreInstance;
            try {
                Class<TieredMetadataStore> clazz2 = Class.forName(storeConfig.getTieredMetadataServiceProvider()).asSubclass(TieredMetadataStore.class);
                Constructor<TieredMetadataStore> constructor = clazz2.getConstructor(TieredMessageStoreConfig.class);
                metadataStoreInstance = constructor.newInstance(storeConfig);
            }
            catch (Exception e) {
                logger.error("TieredMetadataStore#getInstance: build metadata store failed, provider class: {}", (Object)storeConfig.getTieredMetadataServiceProvider(), (Object)e);
            }
            return metadataStoreInstance;
        }
    }

    public static String toPath(MessageQueue mq) {
        return mq.getBrokerName() + File.separator + mq.getTopic() + File.separator + mq.getQueueId();
    }
}

