/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.example.benchmark;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.SendStatus;
import org.apache.rocketmq.common.compression.CompressionType;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.example.benchmark.AclClient;
import org.apache.rocketmq.example.benchmark.StatsBenchmarkBatchProducer;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.apache.rocketmq.remoting.protocol.SerializeType;
import org.apache.rocketmq.srvutil.ServerUtil;

public class BatchProducer {
    private static byte[] msgBody;

    public static void main(String[] args) throws MQClientException {
        System.setProperty("rocketmq.serialize.type", SerializeType.ROCKETMQ.name());
        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
        CommandLine commandLine = ServerUtil.parseCmdLine((String)"benchmarkBatchProducer", (String[])args, (Options)BatchProducer.buildCommandlineOptions(options), (CommandLineParser)new DefaultParser());
        if (null == commandLine) {
            System.exit(-1);
        }
        String namesrv = BatchProducer.getOptionValue(commandLine, 'n', "127.0.0.1:9876");
        final String topic = BatchProducer.getOptionValue(commandLine, 't', "BenchmarkTest");
        int threadCount = BatchProducer.getOptionValue(commandLine, 'w', 64);
        int messageSize = BatchProducer.getOptionValue(commandLine, 's', 128);
        final int batchSize = BatchProducer.getOptionValue(commandLine, 'b', 16);
        final boolean keyEnable = BatchProducer.getOptionValue(commandLine, 'k', false);
        final int propertySize = BatchProducer.getOptionValue(commandLine, 'p', 0);
        final int tagCount = BatchProducer.getOptionValue(commandLine, 'l', 0);
        boolean msgTraceEnable = BatchProducer.getOptionValue(commandLine, 'm', false);
        boolean aclEnable = BatchProducer.getOptionValue(commandLine, 'a', false);
        boolean enableCompress = commandLine.hasOption('c') && Boolean.parseBoolean(commandLine.getOptionValue('c'));
        int reportInterval = commandLine.hasOption("ri") ? Integer.parseInt(commandLine.getOptionValue("ri")) : 10000;
        System.out.printf("topic: %s, threadCount: %d, messageSize: %d, batchSize: %d, keyEnable: %s, propertySize: %d, tagCount: %d, traceEnable: %s, aclEnable: %s%n compressEnable: %s, reportInterval: %d%n", topic, threadCount, messageSize, batchSize, keyEnable, propertySize, tagCount, msgTraceEnable, aclEnable, enableCompress, reportInterval);
        StringBuilder sb = new StringBuilder(messageSize);
        for (int i = 0; i < messageSize; ++i) {
            sb.append(RandomStringUtils.randomAlphanumeric((int)1));
        }
        msgBody = sb.toString().getBytes(StandardCharsets.UTF_8);
        final StatsBenchmarkBatchProducer statsBenchmark = new StatsBenchmarkBatchProducer(reportInterval);
        statsBenchmark.start();
        RPCHook rpcHook = null;
        if (aclEnable) {
            String ak = commandLine.hasOption("ak") ? String.valueOf(commandLine.getOptionValue("ak")) : "rocketmq2";
            String sk = commandLine.hasOption("sk") ? String.valueOf(commandLine.getOptionValue("sk")) : "12345678";
            rpcHook = AclClient.getAclRPCHook(ak, sk);
        }
        final DefaultMQProducer producer = BatchProducer.initInstance(namesrv, msgTraceEnable, rpcHook);
        if (enableCompress) {
            String compressType = commandLine.hasOption("ct") ? commandLine.getOptionValue("ct").trim() : "ZLIB";
            int compressLevel = commandLine.hasOption("cl") ? Integer.parseInt(commandLine.getOptionValue("cl")) : 5;
            int compressOverHowMuch = commandLine.hasOption("ch") ? Integer.parseInt(commandLine.getOptionValue("ch")) : 4096;
            producer.getDefaultMQProducerImpl().setCompressType(CompressionType.of((String)compressType));
            producer.getDefaultMQProducerImpl().setCompressLevel(compressLevel);
            producer.setCompressMsgBodyOverHowmuch(compressOverHowMuch);
            System.out.printf("compressType: %s compressLevel: %s%n", compressType, compressLevel);
        } else {
            producer.setCompressMsgBodyOverHowmuch(Integer.MAX_VALUE);
        }
        producer.start();
        final Logger logger = LoggerFactory.getLogger(BatchProducer.class);
        ExecutorService sendThreadPool = Executors.newFixedThreadPool(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            sendThreadPool.execute(new Runnable(){

                @Override
                public void run() {
                    List msgs;
                    block11: while (!CollectionUtils.isEmpty((Collection)(msgs = BatchProducer.buildBathMessage(batchSize, topic)))) {
                        try {
                            long beginTimestamp = System.currentTimeMillis();
                            long sendSucCount = statsBenchmark.getSendMessageSuccessCount().longValue();
                            BatchProducer.setKeys(keyEnable, msgs, String.valueOf(beginTimestamp / 1000L));
                            BatchProducer.setTags(tagCount, msgs, sendSucCount);
                            BatchProducer.setProperties(propertySize, msgs);
                            SendResult sendResult = producer.send((Collection)msgs);
                            if (sendResult.getSendStatus() == SendStatus.SEND_OK) {
                                statsBenchmark.getSendRequestSuccessCount().increment();
                                statsBenchmark.getSendMessageSuccessCount().add(msgs.size());
                            } else {
                                statsBenchmark.getSendRequestFailedCount().increment();
                                statsBenchmark.getSendMessageFailedCount().add(msgs.size());
                            }
                            long currentRT = System.currentTimeMillis() - beginTimestamp;
                            statsBenchmark.getSendMessageSuccessTimeTotal().add(currentRT);
                            long prevMaxRT = statsBenchmark.getSendMessageMaxRT().longValue();
                            while (true) {
                                boolean updated;
                                if (currentRT <= prevMaxRT || (updated = statsBenchmark.getSendMessageMaxRT().compareAndSet(prevMaxRT, currentRT))) continue block11;
                                prevMaxRT = statsBenchmark.getSendMessageMaxRT().get();
                            }
                        }
                        catch (RemotingException e) {
                            statsBenchmark.getSendRequestFailedCount().increment();
                            statsBenchmark.getSendMessageFailedCount().add(msgs.size());
                            logger.error("[BENCHMARK_PRODUCER] Send Exception", (Throwable)e);
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        catch (InterruptedException e) {
                            statsBenchmark.getSendRequestFailedCount().increment();
                            statsBenchmark.getSendMessageFailedCount().add(msgs.size());
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            statsBenchmark.getSendRequestFailedCount().increment();
                            statsBenchmark.getSendMessageFailedCount().add(msgs.size());
                            logger.error("[BENCHMARK_PRODUCER] Send Exception", (Throwable)e);
                            continue;
                        }
                        catch (MQClientException e) {
                            statsBenchmark.getSendRequestFailedCount().increment();
                            statsBenchmark.getSendMessageFailedCount().add(msgs.size());
                            logger.error("[BENCHMARK_PRODUCER] Send Exception", (Throwable)e);
                            continue;
                        }
                        catch (MQBrokerException e) {
                            statsBenchmark.getSendRequestFailedCount().increment();
                            statsBenchmark.getSendMessageFailedCount().add(msgs.size());
                            logger.error("[BENCHMARK_PRODUCER] Send Exception", (Throwable)e);
                            try {
                                Thread.sleep(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            continue;
                        }
                        break;
                    }
                    return;
                }
            });
        }
    }

    public static Options buildCommandlineOptions(Options options) {
        Option opt = new Option("w", "threadCount", true, "Thread count, Default: 64");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("s", "messageSize", true, "Message Size, Default: 128");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("b", "batchSize", true, "Batch Size, Default: 16");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("k", "keyEnable", true, "Message Key Enable, Default: false");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("t", "topic", true, "Topic name, Default: BenchmarkTest");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("l", "tagCount", true, "Tag count, Default: 0");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("m", "msgTraceEnable", true, "Message Trace Enable, Default: false");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("a", "aclEnable", true, "Acl Enable, Default: false");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("ak", "accessKey", true, "Acl Access Key, Default: rocketmq2");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("sk", "secretKey", true, "Acl Secret Key, Default: 123456789");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("p", "propertySize", true, "Property Size, Default: 0");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("n", "namesrv", true, "name server, Default: 127.0.0.1:9876");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("c", "compressEnable", true, "Enable compress msg over 4K, Default: false");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("ct", "compressType", true, "Message compressed type, Default: ZLIB");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("cl", "compressLevel", true, "Message compressed level, Default: 5");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("ch", "compressOverHowMuch", true, "Compress message when body over how much(unit Byte), Default: 4096");
        opt.setRequired(false);
        options.addOption(opt);
        opt = new Option("ri", "reportInterval", true, "The number of ms between reports, Default: 10000");
        opt.setRequired(false);
        options.addOption(opt);
        return options;
    }

    private static String getOptionValue(CommandLine commandLine, char key, String defaultValue) {
        if (commandLine.hasOption(key)) {
            return commandLine.getOptionValue(key).trim();
        }
        return defaultValue;
    }

    private static int getOptionValue(CommandLine commandLine, char key, int defaultValue) {
        if (commandLine.hasOption(key)) {
            return Integer.parseInt(commandLine.getOptionValue(key).trim());
        }
        return defaultValue;
    }

    private static boolean getOptionValue(CommandLine commandLine, char key, boolean defaultValue) {
        if (commandLine.hasOption(key)) {
            return Boolean.parseBoolean(commandLine.getOptionValue(key).trim());
        }
        return defaultValue;
    }

    private static List<Message> buildBathMessage(int batchSize, String topic) {
        ArrayList<Message> batchMessage = new ArrayList<Message>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            Message msg = new Message(topic, msgBody);
            batchMessage.add(msg);
        }
        return batchMessage;
    }

    private static void setKeys(boolean keyEnable, List<Message> msgs, String keys) {
        if (!keyEnable) {
            return;
        }
        for (Message msg : msgs) {
            msg.setKeys(keys);
        }
    }

    private static void setTags(int tagCount, List<Message> msgs, long startTagId) {
        if (tagCount <= 0) {
            return;
        }
        long tagId = startTagId % (long)tagCount;
        for (Message msg : msgs) {
            msg.setTags(String.format("tag%d", tagId++));
        }
    }

    private static void setProperties(int propertySize, List<Message> msgs) {
        if (propertySize <= 0) {
            return;
        }
        block0: for (Message msg : msgs) {
            if (msg.getProperties() != null) {
                msg.getProperties().clear();
            }
            int startValue = new Random(System.currentTimeMillis()).nextInt(100);
            int size = 0;
            int i = 0;
            while (true) {
                String prop1 = "prop" + i;
                String prop1V = "hello" + startValue;
                msg.putUserProperty(prop1, prop1V);
                if ((size += prop1.length() + prop1V.length()) > propertySize) continue block0;
                ++startValue;
                ++i;
            }
        }
    }

    private static DefaultMQProducer initInstance(String namesrv, boolean traceEnable, RPCHook rpcHook) {
        DefaultMQProducer producer = new DefaultMQProducer("benchmark_batch_producer", rpcHook, traceEnable, null);
        producer.setInstanceName(Long.toString(System.currentTimeMillis()));
        producer.setNamesrvAddr(namesrv);
        return producer;
    }
}

