/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.grpc.interceptor;

import com.google.common.net.HostAndPort;
import io.grpc.Grpc;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.rocketmq.proxy.grpc.interceptor.InterceptorConstants;

public class HeaderInterceptor
implements ServerInterceptor {
    public <R, W> ServerCall.Listener<R> interceptCall(ServerCall<R, W> call, Metadata headers, ServerCallHandler<R, W> next) {
        SocketAddress remoteSocketAddress = (SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
        String remoteAddress = this.parseSocketAddress(remoteSocketAddress);
        headers.put(InterceptorConstants.REMOTE_ADDRESS, (Object)remoteAddress);
        SocketAddress localSocketAddress = (SocketAddress)call.getAttributes().get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR);
        String localAddress = this.parseSocketAddress(localSocketAddress);
        headers.put(InterceptorConstants.LOCAL_ADDRESS, (Object)localAddress);
        return next.startCall(call, headers);
    }

    private String parseSocketAddress(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            return HostAndPort.fromParts((String)inetSocketAddress.getAddress().getHostAddress(), (int)inetSocketAddress.getPort()).toString();
        }
        return "";
    }
}

