/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.common;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.exception.RemotingConnectException;
import org.apache.rocketmq.remoting.exception.RemotingSendRequestException;
import org.apache.rocketmq.remoting.exception.RemotingTimeoutException;
import org.apache.rocketmq.remoting.netty.NettySystemConfig;
import org.apache.rocketmq.remoting.protocol.LanguageCode;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.RequestCode;
import org.apache.rocketmq.remoting.protocol.ResponseCode;

public class RemotingHelper {
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String DEFAULT_CIDR_ALL = "0.0.0.0/0";
    private static final Logger log = LoggerFactory.getLogger((String)"RocketmqRemoting");
    private static final AttributeKey<String> REMOTE_ADDR_KEY = AttributeKey.valueOf((String)"RemoteAddr");
    public static final AttributeKey<String> CLIENT_ID_KEY = AttributeKey.valueOf((String)"ClientId");
    public static final AttributeKey<Integer> VERSION_KEY = AttributeKey.valueOf((String)"Version");
    public static final AttributeKey<LanguageCode> LANGUAGE_CODE_KEY = AttributeKey.valueOf((String)"LanguageCode");
    public static final Map<Integer, String> REQUEST_CODE_MAP = new HashMap<Integer, String>(){
        {
            try {
                Field[] f;
                for (Field field : f = RequestCode.class.getFields()) {
                    if (field.getType() != Integer.TYPE) continue;
                    this.put(Integer.valueOf((Integer)field.get(null)), field.getName().toLowerCase());
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    };
    public static final Map<Integer, String> RESPONSE_CODE_MAP = new HashMap<Integer, String>(){
        {
            try {
                Field[] f;
                for (Field field : f = ResponseCode.class.getFields()) {
                    if (field.getType() != Integer.TYPE) continue;
                    this.put(Integer.valueOf((Integer)field.get(null)), field.getName().toLowerCase());
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    };

    public static <T> T getAttributeValue(AttributeKey<T> key, Channel channel) {
        if (channel.hasAttr(key)) {
            Attribute attribute = channel.attr(key);
            return (T)attribute.get();
        }
        return null;
    }

    public static <T> void setPropertyToAttr(Channel channel, AttributeKey<T> attributeKey, T value) {
        if (channel == null) {
            return;
        }
        channel.attr(attributeKey).set(value);
    }

    public static SocketAddress string2SocketAddress(String addr) {
        int split = addr.lastIndexOf(":");
        String host = addr.substring(0, split);
        String port = addr.substring(split + 1);
        InetSocketAddress isa = new InetSocketAddress(host, Integer.parseInt(port));
        return isa;
    }

    public static RemotingCommand invokeSync(String addr, RemotingCommand request, long timeoutMillis) throws InterruptedException, RemotingConnectException, RemotingSendRequestException, RemotingTimeoutException, RemotingCommandException {
        long beginTime = System.currentTimeMillis();
        SocketAddress socketAddress = NetworkUtil.string2SocketAddress((String)addr);
        SocketChannel socketChannel = RemotingHelper.connect(socketAddress);
        if (socketChannel != null) {
            boolean sendRequestOK = false;
            try {
                socketChannel.configureBlocking(true);
                socketChannel.socket().setSoTimeout((int)timeoutMillis);
                ByteBuffer byteBufferRequest = request.encode();
                while (byteBufferRequest.hasRemaining()) {
                    int length = socketChannel.write(byteBufferRequest);
                    if (length > 0) {
                        if (byteBufferRequest.hasRemaining() && System.currentTimeMillis() - beginTime > timeoutMillis) {
                            throw new RemotingSendRequestException(addr);
                        }
                    } else {
                        throw new RemotingSendRequestException(addr);
                    }
                    Thread.sleep(1L);
                }
                sendRequestOK = true;
                ByteBuffer byteBufferSize = ByteBuffer.allocate(4);
                while (byteBufferSize.hasRemaining()) {
                    int length = socketChannel.read(byteBufferSize);
                    if (length > 0) {
                        if (byteBufferSize.hasRemaining() && System.currentTimeMillis() - beginTime > timeoutMillis) {
                            throw new RemotingTimeoutException(addr, timeoutMillis);
                        }
                    } else {
                        throw new RemotingTimeoutException(addr, timeoutMillis);
                    }
                    Thread.sleep(1L);
                }
                int size = byteBufferSize.getInt(0);
                ByteBuffer byteBufferBody = ByteBuffer.allocate(size);
                while (byteBufferBody.hasRemaining()) {
                    int length = socketChannel.read(byteBufferBody);
                    if (length > 0) {
                        if (byteBufferBody.hasRemaining() && System.currentTimeMillis() - beginTime > timeoutMillis) {
                            throw new RemotingTimeoutException(addr, timeoutMillis);
                        }
                    } else {
                        throw new RemotingTimeoutException(addr, timeoutMillis);
                    }
                    Thread.sleep(1L);
                }
                byteBufferBody.flip();
                RemotingCommand remotingCommand = RemotingCommand.decode(byteBufferBody);
                return remotingCommand;
            }
            catch (IOException e) {
                log.error("invokeSync failure", (Throwable)e);
                if (sendRequestOK) {
                    throw new RemotingTimeoutException(addr, timeoutMillis);
                }
                throw new RemotingSendRequestException(addr);
            }
            finally {
                try {
                    socketChannel.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        throw new RemotingConnectException(addr);
    }

    public static String parseChannelRemoteAddr(Channel channel) {
        if (null == channel) {
            return "";
        }
        Attribute att = channel.attr(REMOTE_ADDR_KEY);
        if (att == null) {
            return RemotingHelper.parseChannelRemoteAddr0(channel);
        }
        String addr = (String)att.get();
        if (addr == null) {
            addr = RemotingHelper.parseChannelRemoteAddr0(channel);
            att.set((Object)addr);
        }
        return addr;
    }

    private static String parseChannelRemoteAddr0(Channel channel) {
        String addr;
        SocketAddress remote = channel.remoteAddress();
        String string = addr = remote != null ? remote.toString() : "";
        if (addr.length() > 0) {
            int index = addr.lastIndexOf("/");
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }

    public static String parseHostFromAddress(String address) {
        if (address == null) {
            return "";
        }
        String[] addressSplits = address.split(":");
        if (addressSplits.length < 1) {
            return "";
        }
        return addressSplits[0];
    }

    public static String parseSocketAddressAddr(SocketAddress socketAddress) {
        if (socketAddress != null) {
            String addr = socketAddress.toString();
            int index = addr.lastIndexOf("/");
            return index != -1 ? addr.substring(index + 1) : addr;
        }
        return "";
    }

    public static int parseSocketAddressPort(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            return ((InetSocketAddress)socketAddress).getPort();
        }
        return -1;
    }

    public static int ipToInt(String ip) {
        String[] ips = ip.split("\\.");
        return Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
    }

    public static boolean ipInCIDR(String ip, String cidr) {
        int cidrIpAddr;
        String[] cidrArr;
        int netId;
        int mask;
        int ipAddr = RemotingHelper.ipToInt(ip);
        return (ipAddr & (mask = -1 << 32 - (netId = Integer.parseInt((cidrArr = cidr.split("/"))[1])))) == ((cidrIpAddr = RemotingHelper.ipToInt(cidrArr[0])) & mask);
    }

    public static SocketChannel connect(SocketAddress remote) {
        return RemotingHelper.connect(remote, 5000);
    }

    public static SocketChannel connect(SocketAddress remote, int timeoutMillis) {
        SocketChannel sc = null;
        try {
            sc = SocketChannel.open();
            sc.configureBlocking(true);
            sc.socket().setSoLinger(false, -1);
            sc.socket().setTcpNoDelay(true);
            if (NettySystemConfig.socketSndbufSize > 0) {
                sc.socket().setReceiveBufferSize(NettySystemConfig.socketSndbufSize);
            }
            if (NettySystemConfig.socketRcvbufSize > 0) {
                sc.socket().setSendBufferSize(NettySystemConfig.socketRcvbufSize);
            }
            sc.socket().connect(remote, timeoutMillis);
            sc.configureBlocking(false);
            return sc;
        }
        catch (Exception e) {
            if (sc != null) {
                try {
                    sc.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            return null;
        }
    }

    public static void closeChannel(Channel channel) {
        final String addrRemote = RemotingHelper.parseChannelRemoteAddr(channel);
        if ("".equals(addrRemote)) {
            channel.close();
        } else {
            channel.close().addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    log.info("closeChannel: close the connection to remote address[{}] result: {}", (Object)addrRemote, (Object)future.isSuccess());
                }
            });
        }
    }

    public static String getRequestCodeDesc(int code) {
        return REQUEST_CODE_MAP.getOrDefault(code, String.valueOf(code));
    }

    public static String getResponseCodeDesc(int code) {
        return RESPONSE_CODE_MAP.getOrDefault(code, String.valueOf(code));
    }
}

