/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authz.handler.jwt;

import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.ranger.authz.handler.RangerAuth;
import org.apache.ranger.authz.handler.jwt.RangerJwtAuthHandler;

public class RangerDefaultJwtAuthHandler
extends RangerJwtAuthHandler {
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected static final String DO_AS_PARAMETER = "doAs";

    @Override
    public ConfigurableJWTProcessor<SecurityContext> getJwtProcessor(JWSKeySelector<SecurityContext> keySelector) {
        DefaultJWTProcessor jwtProcessor = new DefaultJWTProcessor();
        DefaultJWTClaimsVerifier claimsVerifier = new DefaultJWTClaimsVerifier();
        jwtProcessor.setJWSKeySelector(keySelector);
        jwtProcessor.setJWTClaimsSetVerifier((JWTClaimsSetVerifier)claimsVerifier);
        return jwtProcessor;
    }

    @Override
    public RangerAuth authenticate(HttpServletRequest httpServletRequest) {
        String doAsUser;
        String jwtAuthHeaderStr;
        RangerAuth rangerAuth = null;
        String jwtCookieStr = StringUtils.isBlank((String)(jwtAuthHeaderStr = RangerDefaultJwtAuthHandler.getJwtAuthHeader(httpServletRequest))) ? RangerDefaultJwtAuthHandler.getJwtCookie(httpServletRequest) : null;
        AuthenticationToken authenticationToken = this.authenticate(jwtAuthHeaderStr, jwtCookieStr, doAsUser = httpServletRequest.getParameter(DO_AS_PARAMETER));
        if (authenticationToken != null) {
            rangerAuth = new RangerAuth(authenticationToken, RangerAuth.AUTH_TYPE.JWT_JWKS);
        }
        return rangerAuth;
    }

    public static boolean canAuthenticateRequest(ServletRequest request) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String jwtAuthHeaderStr = RangerDefaultJwtAuthHandler.getJwtAuthHeader(httpServletRequest);
        String jwtCookieStr = StringUtils.isBlank((String)jwtAuthHeaderStr) ? RangerDefaultJwtAuthHandler.getJwtCookie(httpServletRequest) : null;
        return RangerDefaultJwtAuthHandler.shouldProceedAuth(jwtAuthHeaderStr, jwtCookieStr);
    }

    public static String getJwtAuthHeader(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getHeader(AUTHORIZATION_HEADER);
    }

    public static String getJwtCookie(HttpServletRequest httpServletRequest) {
        String jwtCookieStr = null;
        Cookie[] cookies = httpServletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                jwtCookieStr = cookie.getName() + "=" + cookie.getValue();
                break;
            }
        }
        return jwtCookieStr;
    }
}

