/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.type.TypeId;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;

public class ConnectorViewDefinition {
    private final String originalSql;
    private final Optional<String> catalog;
    private final Optional<String> schema;
    private final List<ViewColumn> columns;
    private final Optional<String> comment;
    private final Optional<String> owner;
    private final boolean runAsInvoker;
    private final List<CatalogSchemaName> path;

    @JsonCreator
    public ConnectorViewDefinition(@JsonProperty(value="originalSql") String originalSql, @JsonProperty(value="catalog") Optional<String> catalog, @JsonProperty(value="schema") Optional<String> schema, @JsonProperty(value="columns") List<ViewColumn> columns, @JsonProperty(value="comment") Optional<String> comment, @JsonProperty(value="owner") Optional<String> owner, @JsonProperty(value="runAsInvoker") boolean runAsInvoker, @JsonProperty(value="path") List<CatalogSchemaName> path) {
        this.originalSql = Objects.requireNonNull(originalSql, "originalSql is null");
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.columns = List.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.comment = Objects.requireNonNull(comment, "comment is null");
        this.owner = Objects.requireNonNull(owner, "owner is null");
        this.runAsInvoker = runAsInvoker;
        List<Object> list = this.path = path == null ? List.of() : List.copyOf(path);
        if (catalog.isEmpty() && schema.isPresent()) {
            throw new IllegalArgumentException("catalog must be present if schema is present");
        }
        if (runAsInvoker && owner.isPresent()) {
            throw new IllegalArgumentException("owner cannot be present with runAsInvoker");
        }
        if (columns.isEmpty()) {
            throw new IllegalArgumentException("columns list is empty");
        }
    }

    @JsonProperty
    public String getOriginalSql() {
        return this.originalSql;
    }

    @JsonProperty
    public Optional<String> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public Optional<String> getSchema() {
        return this.schema;
    }

    @JsonProperty
    public List<ViewColumn> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Optional<String> getComment() {
        return this.comment;
    }

    @JsonProperty
    public Optional<String> getOwner() {
        return this.owner;
    }

    @JsonProperty
    public boolean isRunAsInvoker() {
        return this.runAsInvoker;
    }

    @JsonProperty
    public List<CatalogSchemaName> getPath() {
        return this.path;
    }

    public ConnectorViewDefinition withoutOwner() {
        return new ConnectorViewDefinition(this.originalSql, this.catalog, this.schema, this.columns, this.comment, Optional.empty(), this.runAsInvoker, this.path);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        this.owner.ifPresent(value -> joiner.add("owner=" + value));
        this.comment.ifPresent(value -> joiner.add("comment=" + value));
        joiner.add("runAsInvoker=" + this.runAsInvoker);
        joiner.add("columns=" + String.valueOf(this.columns));
        this.catalog.ifPresent(value -> joiner.add("catalog=" + value));
        this.schema.ifPresent(value -> joiner.add("schema=" + value));
        joiner.add(this.path.stream().map(CatalogSchemaName::toString).collect(Collectors.joining(", ", "path=(", ")")));
        joiner.add("originalSql=[" + this.originalSql + "]");
        return this.getClass().getSimpleName() + joiner.toString();
    }

    public static final class ViewColumn {
        private final String name;
        private final TypeId type;
        private final Optional<String> comment;

        @JsonCreator
        public ViewColumn(@JsonProperty(value="name") String name, @JsonProperty(value="type") TypeId type, @JsonProperty(value="comment") Optional<String> comment) {
            this.name = Objects.requireNonNull(name, "name is null");
            this.type = Objects.requireNonNull(type, "type is null");
            this.comment = Objects.requireNonNull(comment, "comment is null");
        }

        @JsonProperty
        public String getName() {
            return this.name;
        }

        @JsonProperty
        public TypeId getType() {
            return this.type;
        }

        @JsonProperty
        public Optional<String> getComment() {
            return this.comment;
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            joiner.add("name=" + this.name);
            joiner.add("type=" + String.valueOf(this.type));
            this.comment.ifPresent(value -> joiner.add("comment=" + value));
            return this.getClass().getSimpleName() + String.valueOf(joiner);
        }
    }
}

