/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.google.errorprone.annotations.Immutable;
import io.trino.spi.connector.ConnectorPartitioningHandle;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class ConnectorTableLayout {
    private final Optional<ConnectorPartitioningHandle> partitioning;
    private final List<String> partitionColumns;
    private final boolean multipleWritersPerPartitionSupported;

    @Deprecated
    public ConnectorTableLayout(ConnectorPartitioningHandle partitioning, List<String> partitionColumns) {
        this(partitioning, partitionColumns, false);
    }

    public ConnectorTableLayout(ConnectorPartitioningHandle partitioning, List<String> partitionColumns, boolean multipleWritersPerPartitionSupported) {
        this.partitioning = Optional.of(Objects.requireNonNull(partitioning, "partitioning is null"));
        this.partitionColumns = List.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.multipleWritersPerPartitionSupported = multipleWritersPerPartitionSupported;
    }

    public ConnectorTableLayout(List<String> partitionColumns) {
        this.partitioning = Optional.empty();
        this.partitionColumns = List.copyOf((Collection)Objects.requireNonNull(partitionColumns, "partitionColumns is null"));
        this.multipleWritersPerPartitionSupported = true;
    }

    public Optional<ConnectorPartitioningHandle> getPartitioning() {
        return this.partitioning;
    }

    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    public boolean supportsMultipleWritersPerPartition() {
        return this.multipleWritersPerPartitionSupported;
    }
}

