/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.storage.AbstractCommitWatcher;
import org.apache.hadoop.hdds.scm.storage.BufferPool;
import org.apache.hadoop.ozone.common.ChunkBuffer;

class CommitWatcher
extends AbstractCommitWatcher<ChunkBuffer> {
    private final BufferPool bufferPool;
    private final ConcurrentMap<Long, CompletableFuture<ContainerProtos.ContainerCommandResponseProto>> futureMap = new ConcurrentHashMap<Long, CompletableFuture<ContainerProtos.ContainerCommandResponseProto>>();

    CommitWatcher(BufferPool bufferPool, XceiverClientSpi xceiverClient) {
        super(xceiverClient);
        this.bufferPool = bufferPool;
    }

    @Override
    void releaseBuffers(long index) {
        long acked = 0L;
        for (ChunkBuffer buffer : this.remove(index)) {
            acked += (long)buffer.position();
            this.bufferPool.releaseBuffer(buffer);
        }
        long totalLength = this.addAckDataLength(acked);
        CompletableFuture removed = (CompletableFuture)this.futureMap.remove(totalLength);
        Objects.requireNonNull(removed, () -> "Future not found for " + totalLength + ": existing = " + this.futureMap.keySet());
    }

    ConcurrentMap<Long, CompletableFuture<ContainerProtos.ContainerCommandResponseProto>> getFutureMap() {
        return this.futureMap;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.futureMap.clear();
    }
}

