/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.protocolPB;

import java.io.IOException;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.om.protocolPB.OmTransport;
import org.apache.hadoop.security.UserGroupInformation;

public interface OmTransportFactory {
    public OmTransport createOmTransport(ConfigurationSource var1, UserGroupInformation var2, String var3) throws IOException;

    public static OmTransport create(ConfigurationSource conf, UserGroupInformation ugi, String omServiceId) throws IOException {
        OmTransportFactory factory = OmTransportFactory.createFactory(conf);
        return factory.createOmTransport(conf, ugi, omServiceId);
    }

    public static OmTransportFactory createFactory(ConfigurationSource conf) throws IOException {
        try {
            ServiceLoader<OmTransportFactory> transportFactoryServiceLoader;
            Iterator<OmTransportFactory> iterator;
            if (conf.get("ozone.om.transport.class", "org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory") != "org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory" && (iterator = (transportFactoryServiceLoader = ServiceLoader.load(OmTransportFactory.class)).iterator()).hasNext()) {
                return iterator.next();
            }
            return OmTransportFactory.class.getClassLoader().loadClass("org.apache.hadoop.ozone.om.protocolPB.Hadoop3OmTransportFactory").asSubclass(OmTransportFactory.class).newInstance();
        }
        catch (Exception ex) {
            throw new IOException("Can't create the default OmTransport implementation", ex);
        }
    }
}

