/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;

@JsonIgnoreProperties(value={"aclBitSet"})
public class OzoneAcl {
    private static final String ACL_SCOPE_REGEX = ".*\\[(ACCESS|DEFAULT)\\]";
    private IAccessAuthorizer.ACLIdentityType type;
    private String name;
    private BitSet aclBitSet;
    private AclScope aclScope;
    private static final List<IAccessAuthorizer.ACLType> EMPTY_LIST = new ArrayList<IAccessAuthorizer.ACLType>(0);
    public static final BitSet ZERO_BITSET = new BitSet(0);

    public OzoneAcl() {
    }

    public OzoneAcl(IAccessAuthorizer.ACLIdentityType type, String name, IAccessAuthorizer.ACLType acl, AclScope scope) {
        this.name = name;
        this.aclBitSet = new BitSet(IAccessAuthorizer.ACLType.getNoOfAcls());
        this.aclBitSet.set(acl.ordinal(), true);
        this.type = type;
        if (type == IAccessAuthorizer.ACLIdentityType.WORLD || type == IAccessAuthorizer.ACLIdentityType.ANONYMOUS) {
            if (!name.equals(IAccessAuthorizer.ACLIdentityType.WORLD.name()) && !name.equals(IAccessAuthorizer.ACLIdentityType.ANONYMOUS.name()) && name.length() != 0) {
                throw new IllegalArgumentException("Unexpected name:{" + name + "} for type WORLD, ANONYMOUS. It should be WORLD & ANONYMOUS respectively.");
            }
            this.name = type.name();
        }
        if ((type == IAccessAuthorizer.ACLIdentityType.USER || type == IAccessAuthorizer.ACLIdentityType.GROUP) && name.length() == 0) {
            throw new IllegalArgumentException("User or group name is required");
        }
        this.aclScope = scope;
    }

    public OzoneAcl(IAccessAuthorizer.ACLIdentityType type, String name, BitSet acls, AclScope scope) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(acls);
        if (acls.cardinality() > IAccessAuthorizer.ACLType.getNoOfAcls()) {
            throw new IllegalArgumentException("Acl bitset passed has unexpected size. bitset size:" + acls.cardinality() + ", bitset:" + acls.toString());
        }
        this.aclBitSet = (BitSet)acls.clone();
        this.name = name;
        this.type = type;
        if (type == IAccessAuthorizer.ACLIdentityType.WORLD || type == IAccessAuthorizer.ACLIdentityType.ANONYMOUS) {
            if (!name.equals(IAccessAuthorizer.ACLIdentityType.WORLD.name()) && !name.equals(IAccessAuthorizer.ACLIdentityType.ANONYMOUS.name()) && name.length() != 0) {
                throw new IllegalArgumentException("Unexpected name:{" + name + "} for type WORLD, ANONYMOUS. It should be WORLD & ANONYMOUS respectively.");
            }
            this.name = type.name();
        }
        if ((type == IAccessAuthorizer.ACLIdentityType.USER || type == IAccessAuthorizer.ACLIdentityType.GROUP) && name.length() == 0) {
            throw new IllegalArgumentException("User or group name is required");
        }
        this.aclScope = scope;
    }

    public static OzoneAcl parseAcl(String acl) throws IllegalArgumentException {
        if (acl == null || acl.isEmpty()) {
            throw new IllegalArgumentException("ACLs cannot be null or empty");
        }
        String[] parts = acl.trim().split(":");
        if (parts.length < 3) {
            throw new IllegalArgumentException("ACLs are not in expected format");
        }
        IAccessAuthorizer.ACLIdentityType aclType = IAccessAuthorizer.ACLIdentityType.valueOf(parts[0].toUpperCase());
        BitSet acls = new BitSet(IAccessAuthorizer.ACLType.getNoOfAcls());
        String bits = parts[2];
        AclScope aclScope = AclScope.ACCESS;
        if (parts[2].matches(ACL_SCOPE_REGEX)) {
            int indexOfOpenBracket = parts[2].indexOf("[");
            bits = parts[2].substring(0, indexOfOpenBracket);
            aclScope = AclScope.valueOf(parts[2].substring(indexOfOpenBracket + 1, parts[2].indexOf("]")));
        }
        for (char ch : bits.toCharArray()) {
            acls.set(IAccessAuthorizer.ACLType.getACLRight(String.valueOf(ch)).ordinal());
        }
        return new OzoneAcl(aclType, parts[1], acls, aclScope);
    }

    public static List<OzoneAcl> parseAcls(String acls) throws IllegalArgumentException {
        if (acls == null || acls.isEmpty()) {
            throw new IllegalArgumentException("ACLs cannot be null or empty");
        }
        String[] parts = acls.trim().split(",");
        if (parts.length < 1) {
            throw new IllegalArgumentException("ACLs are not in expected format");
        }
        ArrayList<OzoneAcl> ozAcls = new ArrayList<OzoneAcl>();
        for (String acl : parts) {
            ozAcls.add(OzoneAcl.parseAcl(acl));
        }
        return ozAcls;
    }

    public static OzoneManagerProtocolProtos.OzoneAclInfo toProtobuf(OzoneAcl acl) {
        OzoneManagerProtocolProtos.OzoneAclInfo.Builder builder = OzoneManagerProtocolProtos.OzoneAclInfo.newBuilder().setName(acl.getName()).setType(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.valueOf((String)acl.getType().name())).setAclScope(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclScope.valueOf((String)acl.getAclScope().name())).setRights(ByteString.copyFrom((byte[])acl.getAclBitSet().toByteArray()));
        return builder.build();
    }

    public static OzoneAcl fromProtobuf(OzoneManagerProtocolProtos.OzoneAclInfo protoAcl) {
        BitSet aclRights = BitSet.valueOf(protoAcl.getRights().toByteArray());
        return new OzoneAcl(IAccessAuthorizer.ACLIdentityType.valueOf(protoAcl.getType().name()), protoAcl.getName(), aclRights, AclScope.valueOf(protoAcl.getAclScope().name()));
    }

    public static OzoneAcl fromProtobufWithAccessType(OzoneManagerProtocolProtos.OzoneAclInfo protoAcl) {
        BitSet aclRights = BitSet.valueOf(protoAcl.getRights().toByteArray());
        return new OzoneAcl(IAccessAuthorizer.ACLIdentityType.valueOf(protoAcl.getType().name()), protoAcl.getName(), aclRights, AclScope.ACCESS);
    }

    public static OzoneManagerProtocolProtos.OzoneAclInfo toProtobufWithAccessType(OzoneAcl acl) {
        OzoneManagerProtocolProtos.OzoneAclInfo.Builder builder = OzoneManagerProtocolProtos.OzoneAclInfo.newBuilder().setName(acl.getName()).setType(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclType.valueOf((String)acl.getType().name())).setAclScope(OzoneManagerProtocolProtos.OzoneAclInfo.OzoneAclScope.ACCESS).setRights(ByteString.copyFrom((byte[])acl.getAclBitSet().toByteArray()));
        return builder.build();
    }

    public AclScope getAclScope() {
        return this.aclScope;
    }

    public String toString() {
        return (Object)((Object)this.type) + ":" + this.name + ":" + IAccessAuthorizer.ACLType.getACLString(this.aclBitSet) + "[" + (Object)((Object)this.aclScope) + "]";
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getName(), this.getAclBitSet(), this.getType().toString(), this.getAclScope()});
    }

    public String getName() {
        return this.name;
    }

    public BitSet getAclBitSet() {
        return this.aclBitSet;
    }

    public List<IAccessAuthorizer.ACLType> getAclList() {
        if (this.aclBitSet != null) {
            return this.aclBitSet.stream().mapToObj(a -> IAccessAuthorizer.ACLType.values()[a]).collect(Collectors.toList());
        }
        return EMPTY_LIST;
    }

    public IAccessAuthorizer.ACLIdentityType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OzoneAcl otherAcl = (OzoneAcl)obj;
        return otherAcl.getName().equals(this.getName()) && otherAcl.getType().equals((Object)this.getType()) && otherAcl.getAclBitSet().equals(this.getAclBitSet()) && otherAcl.getAclScope().equals((Object)this.getAclScope());
    }

    public OzoneAcl setAclScope(AclScope scope) {
        this.aclScope = scope;
        return this;
    }

    public static enum AclScope {
        ACCESS,
        DEFAULT;

    }
}

