/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.LayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.VersionFactoryKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutVersionInstanceFactory<T> {
    private static final Logger LOG = LoggerFactory.getLogger(LayoutVersionInstanceFactory.class);
    private final Map<String, PriorityQueue<VersionedInstance<T>>> instances = new HashMap<String, PriorityQueue<VersionedInstance<T>>>();

    public boolean register(LayoutVersionManager lvm, VersionFactoryKey key, T instance) {
        int version = key.getVersion() == null ? lvm.getSoftwareLayoutVersion() : key.getVersion().intValue();
        Preconditions.checkArgument((lvm.getSoftwareLayoutVersion() >= key.getVersion() ? 1 : 0) != 0, (Object)String.format("Cannot register key %s since the version is greater than the Software layout version %d", key, lvm.getSoftwareLayoutVersion()));
        String primaryKey = key.getKey();
        this.instances.computeIfAbsent(primaryKey, s -> new PriorityQueue<VersionedInstance>(Comparator.comparingInt(o -> ((VersionedInstance)o).version)));
        PriorityQueue<VersionedInstance<T>> versionedInstances = this.instances.get(primaryKey);
        Optional<VersionedInstance> existingInstance = versionedInstances.parallelStream().filter(v -> ((VersionedInstance)v).version == key.getVersion()).findAny();
        if (existingInstance.isPresent()) {
            throw new IllegalArgumentException(String.format("Cannot register key %s since there is an existing entry already.", key));
        }
        if (!versionedInstances.isEmpty() && this.isValid(lvm, version)) {
            VersionedInstance<T> currentPeek = versionedInstances.peek();
            if (((VersionedInstance)currentPeek).version < version) {
                versionedInstances.poll();
                versionedInstances.offer(new VersionedInstance<T>(version, instance));
                return true;
            }
            if (((VersionedInstance)currentPeek).version > lvm.getMetadataLayoutVersion()) {
                versionedInstances.offer(new VersionedInstance<T>(version, instance));
                return true;
            }
            return false;
        }
        versionedInstances.offer(new VersionedInstance<T>(version, instance));
        return true;
    }

    private boolean isValid(LayoutVersionManager lvm, int version) {
        return version <= lvm.getMetadataLayoutVersion();
    }

    public T get(LayoutVersionManager lvm, VersionFactoryKey key) {
        Integer version = key.getVersion();
        if (version == null) {
            version = lvm.getMetadataLayoutVersion();
        }
        Preconditions.checkArgument((lvm.getMetadataLayoutVersion() >= version ? 1 : 0) != 0, (Object)String.format("Cannot get key %s since the version is greater than the Metadata layout version %d", key, lvm.getMetadataLayoutVersion()));
        String primaryKey = key.getKey();
        PriorityQueue<VersionedInstance<T>> versionedInstances = this.instances.get(primaryKey);
        if (versionedInstances == null || versionedInstances.isEmpty()) {
            throw new IllegalArgumentException("No suitable instance found for request : " + key);
        }
        VersionedInstance<T> value = versionedInstances.peek();
        if (value == null || ((VersionedInstance)value).version > version) {
            throw new IllegalArgumentException("No suitable instance found for request : " + key);
        }
        return (T)((VersionedInstance)value).instance;
    }

    public void finalizeFeature(LayoutFeature feature) {
        Iterator<Map.Entry<String, PriorityQueue<VersionedInstance<T>>>> iterator = this.instances.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, PriorityQueue<VersionedInstance<T>>> next = iterator.next();
            PriorityQueue<VersionedInstance<T>> vInstances = next.getValue();
            VersionedInstance<T> prevInstance = null;
            while (!vInstances.isEmpty() && ((VersionedInstance)vInstances.peek()).version < feature.layoutVersion()) {
                prevInstance = vInstances.poll();
                LOG.info("Unregistering {} from factory. ", ((VersionedInstance)prevInstance).instance);
            }
            if ((vInstances.isEmpty() || ((VersionedInstance)vInstances.peek()).version > feature.layoutVersion()) && prevInstance != null) {
                LOG.info("Re-registering {} with factory. ", ((VersionedInstance)prevInstance).instance);
                vInstances.offer(prevInstance);
            }
            if (!vInstances.isEmpty()) continue;
            LOG.info("Unregistering '{}' from factory since it has no entries.", (Object)next.getKey());
            iterator.remove();
        }
    }

    @VisibleForTesting
    protected Map<String, List<T>> getInstances() {
        HashMap instancesCopy = new HashMap();
        this.instances.forEach((key, value) -> {
            List collect = value.stream().map(v -> ((VersionedInstance)v).instance).collect(Collectors.toList());
            instancesCopy.put(key, collect);
        });
        return Collections.unmodifiableMap(instancesCopy);
    }

    static class VersionedInstance<T> {
        private int version;
        private T instance;

        VersionedInstance(int version, T instance) {
            this.version = version;
            this.instance = instance;
        }

        public long getVersion() {
            return this.version;
        }

        public T getInstance() {
            return this.instance;
        }
    }
}

