/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.upgrade;

import java.io.IOException;
import org.apache.hadoop.ozone.upgrade.AbstractLayoutVersionManager;
import org.apache.hadoop.ozone.upgrade.BasicUpgradeFinalizer;
import org.apache.hadoop.ozone.upgrade.LayoutFeature;
import org.apache.hadoop.ozone.upgrade.UpgradeException;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizationExecutor;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUpgradeFinalizationExecutor<T>
implements UpgradeFinalizationExecutor<T> {
    static final Logger LOG = LoggerFactory.getLogger(DefaultUpgradeFinalizationExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(T component, BasicUpgradeFinalizer<T, ?> finalizer) throws IOException {
        try {
            finalizer.emitStartingMsg();
            finalizer.preFinalizeUpgrade(component);
            this.finalizeFeatures(component, finalizer, ((AbstractLayoutVersionManager)finalizer.getVersionManager()).unfinalizedFeatures());
            finalizer.postFinalizeUpgrade(component);
            finalizer.emitFinishedMsg();
        }
        catch (Exception e) {
            LOG.warn("Upgrade Finalization failed with following Exception. ", (Throwable)e);
            if (((AbstractLayoutVersionManager)finalizer.getVersionManager()).needsFinalization()) {
                ((AbstractLayoutVersionManager)finalizer.getVersionManager()).setUpgradeState(UpgradeFinalizer.Status.FINALIZATION_REQUIRED);
                throw e;
            }
        }
        finally {
            finalizer.markFinalizationDone();
        }
    }

    protected void finalizeFeatures(T component, BasicUpgradeFinalizer<T, ?> finalizer, Iterable<LayoutFeature> lfs) throws UpgradeException {
        for (LayoutFeature lf : lfs) {
            finalizer.finalizeLayoutFeature(lf, component);
        }
    }
}

