/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.lease;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.ozone.lease.LeaseExpiredException;
import org.apache.hadoop.util.Time;

public class Lease<T> {
    private final T resource;
    private final long creationTime;
    private final AtomicLong leaseTimeout;
    private boolean expired;
    private List<Callable<Void>> callbacks;

    public Lease(T resource, long timeout) {
        this.resource = resource;
        this.leaseTimeout = new AtomicLong(timeout);
        this.callbacks = Collections.synchronizedList(new ArrayList());
        this.creationTime = Time.monotonicNow();
        this.expired = false;
    }

    public Lease(T resource, long timeout, Callable<Void> callback) {
        this(resource, timeout);
        this.callbacks.add(callback);
    }

    public boolean hasExpired() {
        return this.expired;
    }

    public long getElapsedTime() throws LeaseExpiredException {
        if (this.hasExpired()) {
            throw new LeaseExpiredException(Lease.messageForResource(this.resource));
        }
        return Time.monotonicNow() - this.creationTime;
    }

    public long getRemainingTime() throws LeaseExpiredException {
        return this.getLeaseLifeTime() - this.getElapsedTime();
    }

    public long getLeaseLifeTime() throws LeaseExpiredException {
        if (this.hasExpired()) {
            throw new LeaseExpiredException(Lease.messageForResource(this.resource));
        }
        return this.leaseTimeout.get();
    }

    public void renew(long timeout) throws LeaseExpiredException {
        if (this.hasExpired()) {
            throw new LeaseExpiredException(Lease.messageForResource(this.resource));
        }
        this.leaseTimeout.addAndGet(timeout);
    }

    public int hashCode() {
        return Objects.hashCode(this.resource);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || this.getClass() != obj.getClass()) {
            return false;
        }
        Lease other = (Lease)obj;
        return Objects.equals(this.resource, other.resource);
    }

    public String toString() {
        return "Lease<" + this.resource + ">";
    }

    List<Callable<Void>> getCallbacks() {
        return this.callbacks;
    }

    void invalidate() {
        this.callbacks = null;
        this.expired = true;
    }

    static String messageForResource(Object resource) {
        return "Resource: " + resource;
    }
}

