/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.storage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.XceiverClientReply;
import org.apache.hadoop.hdds.scm.XceiverClientSpi;
import org.apache.hadoop.hdds.scm.container.common.helpers.BlockNotCommittedException;
import org.apache.hadoop.hdds.scm.container.common.helpers.ContainerNotOpenException;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;
import org.apache.hadoop.hdds.security.token.OzoneBlockTokenIdentifier;
import org.apache.hadoop.ozone.common.Checksum;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.ratis.thirdparty.com.google.protobuf.ByteString;
import org.apache.ratis.util.function.CheckedFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ContainerProtocolCalls {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerProtocolCalls.class);
    private static final List<XceiverClientSpi.Validator> VALIDATORS = ContainerProtocolCalls.createValidators();

    private ContainerProtocolCalls() {
    }

    public static ContainerProtos.ListBlockResponseProto listBlock(XceiverClientSpi xceiverClient, long containerID, Long startLocalID, int count, Token<? extends TokenIdentifier> token) throws IOException {
        ContainerProtos.ListBlockRequestProto.Builder listBlockBuilder = ContainerProtos.ListBlockRequestProto.newBuilder().setCount(count);
        if (startLocalID != null) {
            listBlockBuilder.setStartLocalID(startLocalID.longValue());
        }
        String datanodeID = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.ListBlock).setContainerID(containerID).setDatanodeUuid(datanodeID).setListBlock(listBlockBuilder.build());
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getListBlock();
    }

    static <T> T tryEachDatanode(Pipeline pipeline, CheckedFunction<DatanodeDetails, T, IOException> op, Function<DatanodeDetails, String> toErrorMessage) throws IOException {
        HashSet<DatanodeDetails> excluded = new HashSet<DatanodeDetails>();
        while (true) {
            DatanodeDetails d = pipeline.getClosestNode(excluded);
            try {
                return (T)op.apply((Object)d);
            }
            catch (IOException e) {
                excluded.add(d);
                if (excluded.size() < pipeline.size()) {
                    LOG.warn(toErrorMessage.apply(d) + "; will try another datanode.", (Throwable)e);
                    continue;
                }
                throw e;
            }
            break;
        }
    }

    public static ContainerProtos.GetBlockResponseProto getBlock(XceiverClientSpi xceiverClient, List<XceiverClientSpi.Validator> validators, ContainerProtos.DatanodeBlockID datanodeBlockID, Token<? extends TokenIdentifier> token) throws IOException {
        ContainerProtos.GetBlockRequestProto.Builder readBlockRequest = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(datanodeBlockID);
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetBlock).setContainerID(datanodeBlockID.getContainerID()).setGetBlock(readBlockRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        return (ContainerProtos.GetBlockResponseProto)ContainerProtocolCalls.tryEachDatanode(xceiverClient.getPipeline(), d -> ContainerProtocolCalls.getBlock(xceiverClient, validators, builder, d), d -> ContainerProtocolCalls.toErrorMessage(datanodeBlockID, d));
    }

    static String toErrorMessage(ContainerProtos.DatanodeBlockID blockId, DatanodeDetails d) {
        return String.format("Failed to get block #%s in container #%s from %s", blockId.getLocalID(), blockId.getContainerID(), d);
    }

    public static ContainerProtos.GetBlockResponseProto getBlock(XceiverClientSpi xceiverClient, ContainerProtos.DatanodeBlockID datanodeBlockID, Token<? extends TokenIdentifier> token) throws IOException {
        return ContainerProtocolCalls.getBlock(xceiverClient, ContainerProtocolCalls.getValidatorList(), datanodeBlockID, token);
    }

    private static ContainerProtos.GetBlockResponseProto getBlock(XceiverClientSpi xceiverClient, List<XceiverClientSpi.Validator> validators, ContainerProtos.ContainerCommandRequestProto.Builder builder, DatanodeDetails datanode) throws IOException {
        ContainerProtos.ContainerCommandRequestProto request = builder.setDatanodeUuid(datanode.getUuidString()).build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request, validators);
        return response.getGetBlock();
    }

    public static ContainerProtos.GetCommittedBlockLengthResponseProto getCommittedBlockLength(XceiverClientSpi xceiverClient, BlockID blockID, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        ContainerProtos.GetCommittedBlockLengthRequestProto.Builder getBlockLengthRequestBuilder = ContainerProtos.GetCommittedBlockLengthRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf());
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetCommittedBlockLength).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setGetCommittedBlockLength(getBlockLengthRequestBuilder);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getGetCommittedBlockLength();
    }

    public static ContainerProtos.PutBlockResponseProto putBlock(XceiverClientSpi xceiverClient, ContainerProtos.BlockData containerBlockData, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutBlock).setContainerID(containerBlockData.getBlockID().getContainerID()).setDatanodeUuid(id).setPutBlock(createBlockRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = xceiverClient.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getPutBlock();
    }

    public static XceiverClientReply putBlockAsync(XceiverClientSpi xceiverClient, ContainerProtos.BlockData containerBlockData, boolean eof, Token<? extends TokenIdentifier> token) throws IOException, InterruptedException, ExecutionException {
        ContainerProtos.ContainerCommandRequestProto request = ContainerProtocolCalls.getPutBlockRequest(xceiverClient.getPipeline(), containerBlockData, eof, token);
        return xceiverClient.sendCommandAsync(request);
    }

    public static ContainerProtos.ContainerCommandRequestProto getPutBlockRequest(Pipeline pipeline, ContainerProtos.BlockData containerBlockData, boolean eof, Token<? extends TokenIdentifier> token) throws IOException {
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData).setEof(eof);
        String id = pipeline.getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutBlock).setContainerID(containerBlockData.getBlockID().getContainerID()).setDatanodeUuid(id).setPutBlock(createBlockRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        return builder.build();
    }

    public static ContainerProtos.ReadChunkResponseProto readChunk(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, BlockID blockID, List<XceiverClientSpi.Validator> validators, Token<? extends TokenIdentifier> token) throws IOException {
        ContainerProtos.ReadChunkRequestProto.Builder readChunkRequest = ContainerProtos.ReadChunkRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).setChunkData(chunk).setReadChunkVersion(ContainerProtos.ReadChunkVersion.V1);
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.ReadChunk).setContainerID(blockID.getContainerID()).setReadChunk(readChunkRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        return (ContainerProtos.ReadChunkResponseProto)ContainerProtocolCalls.tryEachDatanode(xceiverClient.getPipeline(), d -> ContainerProtocolCalls.readChunk(xceiverClient, chunk, blockID, validators, builder, d), d -> ContainerProtocolCalls.toErrorMessage(chunk, blockID, d));
    }

    private static ContainerProtos.ReadChunkResponseProto readChunk(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, BlockID blockID, List<XceiverClientSpi.Validator> validators, ContainerProtos.ContainerCommandRequestProto.Builder builder, DatanodeDetails d) throws IOException {
        ContainerProtos.ContainerCommandRequestProto request = builder.setDatanodeUuid(d.getUuidString()).build();
        ContainerProtos.ContainerCommandResponseProto reply = xceiverClient.sendCommand(request, validators);
        ContainerProtos.ReadChunkResponseProto response = reply.getReadChunk();
        long readLen = ContainerProtocolCalls.getLen(response);
        if (readLen != chunk.getLen()) {
            throw new IOException(ContainerProtocolCalls.toErrorMessage(chunk, blockID, d) + ": readLen=" + readLen);
        }
        return response;
    }

    static String toErrorMessage(ContainerProtos.ChunkInfo chunk, BlockID blockId, DatanodeDetails d) {
        return String.format("Failed to read chunk %s (len=%s) %s from %s", chunk.getChunkName(), chunk.getLen(), blockId, d);
    }

    static long getLen(ContainerProtos.ReadChunkResponseProto response) {
        if (response.hasData()) {
            return response.getData().size();
        }
        if (response.hasDataBuffers()) {
            return response.getDataBuffers().getBuffersList().stream().mapToLong(ByteString::size).sum();
        }
        return -1L;
    }

    public static XceiverClientReply writeChunkAsync(XceiverClientSpi xceiverClient, ContainerProtos.ChunkInfo chunk, BlockID blockID, ByteString data, Token<? extends TokenIdentifier> token, int replicationIndex) throws IOException, ExecutionException, InterruptedException {
        ContainerProtos.WriteChunkRequestProto.Builder writeChunkRequest = ContainerProtos.WriteChunkRequestProto.newBuilder().setBlockID(ContainerProtos.DatanodeBlockID.newBuilder().setContainerID(blockID.getContainerID()).setLocalID(blockID.getLocalID()).setBlockCommitSequenceId(blockID.getBlockCommitSequenceId()).setReplicaIndex(replicationIndex).build()).setChunkData(chunk).setData(data);
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.WriteChunk).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setWriteChunk(writeChunkRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        return xceiverClient.sendCommandAsync(request);
    }

    public static ContainerProtos.PutSmallFileResponseProto writeSmallFile(XceiverClientSpi client, BlockID blockID, byte[] data, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        ContainerProtos.BlockData containerBlockData = ContainerProtos.BlockData.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf()).build();
        ContainerProtos.PutBlockRequestProto.Builder createBlockRequest = ContainerProtos.PutBlockRequestProto.newBuilder().setBlockData(containerBlockData);
        ContainerProtos.KeyValue keyValue = ContainerProtos.KeyValue.newBuilder().setKey("OverWriteRequested").setValue("true").build();
        Checksum checksum = new Checksum(ContainerProtos.ChecksumType.CRC32, 256);
        ChecksumData checksumData = checksum.computeChecksum(data);
        ContainerProtos.ChunkInfo chunk = ContainerProtos.ChunkInfo.newBuilder().setChunkName(blockID.getLocalID() + "_chunk").setOffset(0L).setLen((long)data.length).addMetadata(keyValue).setChecksumData(checksumData.getProtoBufMessage()).build();
        ContainerProtos.PutSmallFileRequestProto putSmallFileRequest = ContainerProtos.PutSmallFileRequestProto.newBuilder().setChunkInfo(chunk).setBlock(createBlockRequest).setData(ByteString.copyFrom((byte[])data)).build();
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.PutSmallFile).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setPutSmallFile(putSmallFileRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getPutSmallFile();
    }

    @InterfaceStability.Evolving
    public static void createRecoveringContainer(XceiverClientSpi client, long containerID, String encodedToken, int replicaIndex) throws IOException {
        ContainerProtocolCalls.createContainer(client, containerID, encodedToken, ContainerProtos.ContainerDataProto.State.RECOVERING, replicaIndex);
    }

    public static void createContainer(XceiverClientSpi client, long containerID, String encodedToken) throws IOException {
        ContainerProtocolCalls.createContainer(client, containerID, encodedToken, null, 0);
    }

    public static void createContainer(XceiverClientSpi client, long containerID, String encodedToken, ContainerProtos.ContainerDataProto.State state, int replicaIndex) throws IOException {
        ContainerProtos.CreateContainerRequestProto.Builder createRequest = ContainerProtos.CreateContainerRequestProto.newBuilder();
        createRequest.setContainerType(ContainerProtos.ContainerType.KeyValueContainer);
        if (state != null) {
            createRequest.setState(state);
        }
        if (replicaIndex > 0) {
            createRequest.setReplicaIndex(replicaIndex);
        }
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        request.setCmdType(ContainerProtos.Type.CreateContainer);
        request.setContainerID(containerID);
        request.setCreateContainer(createRequest.build());
        request.setDatanodeUuid(id);
        client.sendCommand(request.build(), ContainerProtocolCalls.getValidatorList());
    }

    public static void deleteContainer(XceiverClientSpi client, long containerID, boolean force, String encodedToken) throws IOException {
        ContainerProtos.DeleteContainerRequestProto.Builder deleteRequest = ContainerProtos.DeleteContainerRequestProto.newBuilder();
        deleteRequest.setForceDelete(force);
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.DeleteContainer);
        request.setContainerID(containerID);
        request.setDeleteContainer(deleteRequest);
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        client.sendCommand(request.build(), ContainerProtocolCalls.getValidatorList());
    }

    public static void closeContainer(XceiverClientSpi client, long containerID, String encodedToken) throws IOException {
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.CloseContainer);
        request.setContainerID(containerID);
        request.setCloseContainer(ContainerProtos.CloseContainerRequestProto.getDefaultInstance());
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        client.sendCommand(request.build(), ContainerProtocolCalls.getValidatorList());
    }

    public static ContainerProtos.ReadContainerResponseProto readContainer(XceiverClientSpi client, long containerID, String encodedToken) throws IOException {
        String id = client.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.ReadContainer);
        request.setContainerID(containerID);
        request.setReadContainer(ContainerProtos.ReadContainerRequestProto.getDefaultInstance());
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request.build(), ContainerProtocolCalls.getValidatorList());
        return response.getReadContainer();
    }

    public static ContainerProtos.GetSmallFileResponseProto readSmallFile(XceiverClientSpi client, BlockID blockID, Token<OzoneBlockTokenIdentifier> token) throws IOException {
        ContainerProtos.GetBlockRequestProto.Builder getBlock = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(blockID.getDatanodeBlockIDProtobuf());
        ContainerProtos.GetSmallFileRequestProto getSmallFileRequest = ContainerProtos.GetSmallFileRequestProto.newBuilder().setBlock(getBlock).setReadChunkVersion(ContainerProtos.ReadChunkVersion.V1).build();
        String id = client.getPipeline().getClosestNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetSmallFile).setContainerID(blockID.getContainerID()).setDatanodeUuid(id).setGetSmallFile(getSmallFileRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        ContainerProtos.ContainerCommandResponseProto response = client.sendCommand(request, ContainerProtocolCalls.getValidatorList());
        return response.getGetSmallFile();
    }

    public static void validateContainerResponse(ContainerProtos.ContainerCommandResponseProto response) throws StorageContainerException {
        if (response.getResult() == ContainerProtos.Result.SUCCESS) {
            return;
        }
        if (response.getResult() == ContainerProtos.Result.BLOCK_NOT_COMMITTED) {
            throw new BlockNotCommittedException(response.getMessage());
        }
        if (response.getResult() == ContainerProtos.Result.CLOSED_CONTAINER_IO) {
            throw new ContainerNotOpenException(response.getMessage());
        }
        throw new StorageContainerException(response.getMessage(), response.getResult());
    }

    public static List<XceiverClientSpi.Validator> getValidatorList() {
        return VALIDATORS;
    }

    private static List<XceiverClientSpi.Validator> createValidators() {
        return Collections.singletonList((request, response) -> ContainerProtocolCalls.validateContainerResponse(response));
    }

    public static List<XceiverClientSpi.Validator> toValidatorList(XceiverClientSpi.Validator validator) {
        List<XceiverClientSpi.Validator> defaults = ContainerProtocolCalls.getValidatorList();
        ArrayList<XceiverClientSpi.Validator> validators = new ArrayList<XceiverClientSpi.Validator>(defaults.size() + 1);
        validators.addAll(defaults);
        validators.add(validator);
        return Collections.unmodifiableList(validators);
    }

    public static HashMap<DatanodeDetails, ContainerProtos.GetBlockResponseProto> getBlockFromAllNodes(XceiverClientSpi xceiverClient, ContainerProtos.DatanodeBlockID datanodeBlockID, Token<OzoneBlockTokenIdentifier> token) throws IOException, InterruptedException {
        ContainerProtos.GetBlockRequestProto.Builder readBlockRequest = ContainerProtos.GetBlockRequestProto.newBuilder().setBlockID(datanodeBlockID);
        HashMap<DatanodeDetails, ContainerProtos.GetBlockResponseProto> datanodeToResponseMap = new HashMap<DatanodeDetails, ContainerProtos.GetBlockResponseProto>();
        String id = xceiverClient.getPipeline().getFirstNode().getUuidString();
        ContainerProtos.ContainerCommandRequestProto.Builder builder = ContainerProtos.ContainerCommandRequestProto.newBuilder().setCmdType(ContainerProtos.Type.GetBlock).setContainerID(datanodeBlockID.getContainerID()).setDatanodeUuid(id).setGetBlock(readBlockRequest);
        if (token != null) {
            builder.setEncodedToken(token.encodeToUrlString());
        }
        ContainerProtos.ContainerCommandRequestProto request = builder.build();
        Map<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> responses = xceiverClient.sendCommandOnAllNodes(request);
        for (Map.Entry<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> entry : responses.entrySet()) {
            datanodeToResponseMap.put(entry.getKey(), entry.getValue().getGetBlock());
        }
        return datanodeToResponseMap;
    }

    public static HashMap<DatanodeDetails, ContainerProtos.ReadContainerResponseProto> readContainerFromAllNodes(XceiverClientSpi client, long containerID, String encodedToken) throws IOException, InterruptedException {
        String id = client.getPipeline().getFirstNode().getUuidString();
        HashMap<DatanodeDetails, ContainerProtos.ReadContainerResponseProto> datanodeToResponseMap = new HashMap<DatanodeDetails, ContainerProtos.ReadContainerResponseProto>();
        ContainerProtos.ContainerCommandRequestProto.Builder request = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        request.setCmdType(ContainerProtos.Type.ReadContainer);
        request.setContainerID(containerID);
        request.setReadContainer(ContainerProtos.ReadContainerRequestProto.getDefaultInstance());
        request.setDatanodeUuid(id);
        if (encodedToken != null) {
            request.setEncodedToken(encodedToken);
        }
        Map<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> responses = client.sendCommandOnAllNodes(request.build());
        for (Map.Entry<DatanodeDetails, ContainerProtos.ContainerCommandResponseProto> entry : responses.entrySet()) {
            datanodeToResponseMap.put(entry.getKey(), entry.getValue().getReadContainer());
        }
        return datanodeToResponseMap;
    }
}

