/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.statistics;

import io.prestosql.spi.block.Block;
import io.prestosql.spi.statistics.ColumnStatisticMetadata;
import io.prestosql.spi.statistics.TableStatisticType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ComputedStatistics {
    private final List<String> groupingColumns;
    private final List<Block> groupingValues;
    private final Map<TableStatisticType, Block> tableStatistics;
    private final Map<ColumnStatisticMetadata, Block> columnStatistics;

    private ComputedStatistics(List<String> groupingColumns, List<Block> groupingValues, Map<TableStatisticType, Block> tableStatistics, Map<ColumnStatisticMetadata, Block> columnStatistics) {
        this.groupingColumns = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(groupingColumns, "groupingColumns is null")));
        this.groupingValues = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(groupingValues, "groupingValues is null")));
        if (!groupingValues.stream().allMatch(ComputedStatistics::isSingleValueBlock)) {
            throw new IllegalArgumentException("grouping value blocks are expected to be single value blocks");
        }
        this.tableStatistics = Collections.unmodifiableMap(new HashMap<TableStatisticType, Block>(Objects.requireNonNull(tableStatistics, "tableStatistics is null")));
        if (!tableStatistics.values().stream().allMatch(ComputedStatistics::isSingleValueBlock)) {
            throw new IllegalArgumentException("computed table statistics blocks are expected to be single value blocks");
        }
        this.columnStatistics = Collections.unmodifiableMap(new HashMap<ColumnStatisticMetadata, Block>(Objects.requireNonNull(columnStatistics, "columnStatistics is null")));
        if (!columnStatistics.values().stream().allMatch(ComputedStatistics::isSingleValueBlock)) {
            throw new IllegalArgumentException("computed column statistics blocks are expected to be single value blocks");
        }
    }

    private static boolean isSingleValueBlock(Block block) {
        return block.getPositionCount() == 1;
    }

    public List<String> getGroupingColumns() {
        return this.groupingColumns;
    }

    public List<Block> getGroupingValues() {
        return this.groupingValues;
    }

    public Map<TableStatisticType, Block> getTableStatistics() {
        return this.tableStatistics;
    }

    public Map<ColumnStatisticMetadata, Block> getColumnStatistics() {
        return this.columnStatistics;
    }

    public static Builder builder(List<String> groupingColumns, List<Block> groupingValues) {
        return new Builder(groupingColumns, groupingValues);
    }

    public static class Builder {
        private final List<String> groupingColumns;
        private final List<Block> groupingValues;
        private final Map<TableStatisticType, Block> tableStatistics = new HashMap<TableStatisticType, Block>();
        private final Map<ColumnStatisticMetadata, Block> columnStatistics = new HashMap<ColumnStatisticMetadata, Block>();

        private Builder(List<String> groupingColumns, List<Block> groupingValues) {
            this.groupingColumns = Objects.requireNonNull(groupingColumns, "groupingColumns is null");
            this.groupingValues = Objects.requireNonNull(groupingValues, "groupingValues is null");
        }

        public Builder addTableStatistic(TableStatisticType type, Block value) {
            this.tableStatistics.put(type, value);
            return this;
        }

        public Builder addColumnStatistic(ColumnStatisticMetadata columnStatisticMetadata, Block value) {
            this.columnStatistics.put(columnStatisticMetadata, value);
            return this;
        }

        public ComputedStatistics build() {
            return new ComputedStatistics(this.groupingColumns, this.groupingValues, this.tableStatistics, this.columnStatistics);
        }
    }
}

