/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.spi.block;

import io.airlift.slice.Slice;
import io.prestosql.spi.block.Block;
import io.prestosql.spi.block.BlockBuilder;
import io.prestosql.spi.block.BlockUtil;
import io.prestosql.spi.block.LazyBlockLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.openjdk.jol.info.ClassLayout;

@NotThreadSafe
public class LazyBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LazyBlock.class).instanceSize() + ClassLayout.parseClass(LazyData.class).instanceSize();
    private final int positionCount;
    private final LazyData lazyData;

    public LazyBlock(int positionCount, LazyBlockLoader loader) {
        this.positionCount = positionCount;
        this.lazyData = new LazyData(positionCount, loader);
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public int getSliceLength(int position) {
        return this.getBlock().getSliceLength(position);
    }

    @Override
    public byte getByte(int position, int offset) {
        return this.getBlock().getByte(position, offset);
    }

    @Override
    public short getShort(int position, int offset) {
        return this.getBlock().getShort(position, offset);
    }

    @Override
    public int getInt(int position, int offset) {
        return this.getBlock().getInt(position, offset);
    }

    @Override
    public long getLong(int position, int offset) {
        return this.getBlock().getLong(position, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        return this.getBlock().getSlice(position, offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        return this.getBlock().getObject(position, clazz);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        return this.getBlock().bytesEqual(position, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        return this.getBlock().bytesCompare(position, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        this.getBlock().writeBytesTo(position, offset, length, blockBuilder);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.getBlock().writePositionTo(position, blockBuilder);
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        return this.getBlock().equals(position, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        return this.getBlock().hash(position, offset, length);
    }

    @Override
    public int compareTo(int leftPosition, int leftOffset, int leftLength, Block rightBlock, int rightPosition, int rightOffset, int rightLength) {
        return this.getBlock().compareTo(leftPosition, leftOffset, leftLength, rightBlock, rightPosition, rightOffset, rightLength);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        return this.getBlock().getSingleValueBlock(position);
    }

    @Override
    public long getSizeInBytes() {
        if (!this.isLoaded()) {
            return 0L;
        }
        return this.getBlock().getSizeInBytes();
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        if (!this.isLoaded()) {
            return 0L;
        }
        return this.getBlock().getRegionSizeInBytes(position, length);
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        if (!this.isLoaded()) {
            return 0L;
        }
        return this.getBlock().getPositionsSizeInBytes(positions);
    }

    @Override
    public long getRetainedSizeInBytes() {
        if (!this.isLoaded()) {
            return INSTANCE_SIZE;
        }
        return (long)INSTANCE_SIZE + this.getBlock().getRetainedSizeInBytes();
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.getBlock().getEstimatedDataSizeForStats(position);
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        this.getBlock().retainedBytesForEachPart(consumer);
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public String getEncodingName() {
        return "LAZY";
    }

    @Override
    public Block getPositions(int[] positions, int offset, int length) {
        if (this.isLoaded()) {
            return this.getBlock().getPositions(positions, offset, length);
        }
        BlockUtil.checkArrayRange(positions, offset, length);
        return new LazyBlock(length, new PositionLazyBlockLoader(this.lazyData, positions, offset, length));
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        return this.getBlock().copyPositions(positions, offset, length);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        if (this.isLoaded()) {
            return this.getBlock().getRegion(positionOffset, length);
        }
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new LazyBlock(length, new RegionLazyBlockLoader(this.lazyData, positionOffset, length));
    }

    @Override
    public Block copyRegion(int position, int length) {
        return this.getBlock().copyRegion(position, length);
    }

    @Override
    public boolean isNull(int position) {
        return this.getBlock().isNull(position);
    }

    @Override
    public final List<Block> getChildren() {
        return Collections.singletonList(this.getBlock());
    }

    public Block getBlock() {
        return this.lazyData.getBlock();
    }

    @Override
    public boolean isLoaded() {
        return this.lazyData.isLoaded();
    }

    @Override
    public Block getLoadedBlock() {
        return this.lazyData.getFullyLoadedBlock();
    }

    public static void listenForLoads(Block block, Consumer<Block> listener) {
        Objects.requireNonNull(block, "block is null");
        Objects.requireNonNull(listener, "listener is null");
        LazyData.addListenersRecursive(block, Collections.singletonList(listener));
    }

    private static class LazyData {
        private final int positionsCount;
        @Nullable
        private LazyBlockLoader loader;
        @Nullable
        private Block block;
        @Nullable
        private List<Consumer<Block>> listeners;

        public LazyData(int positionsCount, LazyBlockLoader loader) {
            this.positionsCount = positionsCount;
            this.loader = Objects.requireNonNull(loader, "loader is null");
        }

        public boolean isLoaded() {
            return this.block != null && this.block.isLoaded();
        }

        public Block getBlock() {
            this.load(false);
            return this.block;
        }

        public Block getFullyLoadedBlock() {
            this.load(true);
            return this.block;
        }

        private void addListeners(List<Consumer<Block>> listeners) {
            if (this.isLoaded()) {
                throw new IllegalStateException("Block is already loaded");
            }
            if (this.listeners == null) {
                this.listeners = new ArrayList<Consumer<Block>>();
            }
            this.listeners.addAll(listeners);
        }

        private void load(boolean recursive) {
            if (this.loader == null) {
                return;
            }
            this.block = Objects.requireNonNull(this.loader.load(), "loader returned null");
            if (this.block.getPositionCount() != this.positionsCount) {
                throw new IllegalStateException(String.format("Loaded block positions count (%s) doesn't match lazy block positions count (%s)", this.block.getPositionCount(), this.positionsCount));
            }
            if (recursive) {
                this.block = this.block.getLoadedBlock();
            } else {
                while (this.block instanceof LazyBlock) {
                    this.block = ((LazyBlock)this.block).getBlock();
                }
            }
            this.loader = null;
            List<Consumer<Block>> listeners = this.listeners;
            this.listeners = null;
            if (listeners != null) {
                listeners.forEach(listener -> listener.accept(this.block));
                if (!recursive) {
                    LazyData.addListenersRecursive(this.block, listeners);
                }
            }
        }

        private static void addListenersRecursive(Block block, List<Consumer<Block>> listeners) {
            LazyData lazyData;
            if (block instanceof LazyBlock && !(lazyData = ((LazyBlock)block).lazyData).isLoaded()) {
                lazyData.addListeners(listeners);
                return;
            }
            for (Block child : block.getChildren()) {
                LazyData.addListenersRecursive(child, listeners);
            }
        }
    }

    private static class PositionLazyBlockLoader
    implements LazyBlockLoader {
        private final LazyData delegate;
        private final int[] positions;
        private final int offset;
        private final int length;

        public PositionLazyBlockLoader(LazyData delegate, int[] positions, int offset, int length) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.positions = Objects.requireNonNull(positions, "positions is null");
            this.offset = offset;
            this.length = length;
        }

        @Override
        public Block load() {
            return this.delegate.getBlock().getPositions(this.positions, this.offset, this.length);
        }
    }

    private static class RegionLazyBlockLoader
    implements LazyBlockLoader {
        private final LazyData delegate;
        private final int positionOffset;
        private final int length;

        public RegionLazyBlockLoader(LazyData delegate, int positionOffset, int length) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.positionOffset = positionOffset;
            this.length = length;
        }

        @Override
        public Block load() {
            return this.delegate.getBlock().getRegion(this.positionOffset, this.length);
        }
    }
}

